from .builder import CUDAOpBuilder


class QuantizerBuilder(CUDAOpBuilder):
    BUILD_VAR = "DS_BUILD_QUANTIZER"
    NAME = "quantizer"

    def __init__(self, name=None):
        name = self.NAME if name is None else name
        super().__init__(name=name)

    def absolute_name(self):
        return f'deepspeed.ops.quantizer.{self.NAME}_op'

    def sources(self):
        return [
            'csrc/quantization/pt_binding.cpp',
            'csrc/quantization/quantizer.cu',
        ]

    def include_paths(self):
        #return ['csrc/includes']
        includes = ['csrc/includes']
        if self.is_rocm_pytorch():
            from torch.utils.cpp_extension import ROCM_HOME
            includes += [
                '{}/hiprand/include'.format(ROCM_HOME),
                '{}/rocrand/include'.format(ROCM_HOME)
            ]
        return includes

    def extra_ldflags(self):
        #return ['-lcurand']
        if not self.is_rocm_pytorch():
            return ['-lcurand']
        else:
            return []
