# Generative Pre-Training2(GPT2)

### 模型介绍

```
GPT2模型：第二代生成式预训练模型（Generative Pre-Training2）。
```

### 模型结构

```
GPT2使用 Transformer 的 Decoder 结构，并对 Transformer Decoder 进行了一些改动，并通过Megatron和deepspeed进行分布式运行
```

### 数据集

```
wget https://huggingface.co/bigscience/misc-test-data/resolve/main/stas/oscar-1GB.jsonl.xz
wget https://s3.amazonaws.com/models.huggingface.co/bert/gpt2-vocab.json
wget https://s3.amazonaws.com/models.huggingface.co/bert/gpt2-merges.txt
xz -d oscar-1GB.jsonl.xz
python tools/preprocess_data.py \
    --input oscar-1GB.jsonl \
    --output-prefix my-gpt2 \
    --vocab gpt2-vocab.json \
    --dataset-impl mmap \
    --tokenizer-type GPT2BPETokenizer \
    --merge-file gpt2-merges.txt \
    --append-eod \
    --workers 8
```

## GPT2预训练

### 环境配置

推荐使用docker方式运行，提供[光源](https://www.sourcefind.cn/#/service-details)拉取的docker镜像：

```
docker pull image.sourcefind.cn:5000/dcu/admin/base/vscode-pytorch:1.10.0-centos7.6-dtk-22.10-py37-latest
```

进入docker

```
pip install -r requirements.txt  -i http://pypi.tuna.tsinghua.edu.cn/simple  --trusted-host pypi.tuna.tsinghua.edu.cn
```

### 训练（单节点）

```
rm megatron/arguments.py
cp megatron/arguments.py-one_node megatron/arguments.py
sh run-train.sh（基于单节点四卡）
```

```
#重要参数
MODEL_NAME 					模型名（自定义）
CHECKPOINT_PATH				模型保存&加载路径
DATA_PATH					数据集路径（转换后的）
TENSORBOARD_PATH			tensorboard路径
CODECARBON_PATH				codecarbon路径

N_GPUS         				使用加速卡数量
TP_SIZE  	 				TP数量
PP_SIZE      				PP数量
MICRO_BATCH_SIZE			MICRO_BATCH_SIZE大小
GLOBAL_BATCH_SIZE           GLOBAL_BATCH_SIZE大小
NLAYERS 					模型层数
NHIDDEN						隐藏层维度
NHEADS						多注意力机制头数
SEQ_LEN						最大长度
SAVE_INTERVAL				保存频率

--train-samples				训练样本数
--eval-interval				验证频率
--eval-iters				验证iter
```

### GPT2模型16B训练(多节点)

要求DCU集群Slurm环境正常。

推荐用户使用预编译好的python3.7包来快速建立python3虚拟环境，pytorch、apex、torchaudio、colossalai、faiss、mmcv-full 、torchvision、tensorflow需要在[光合开发者社区](https://cancon.hpccube.com:65024/4/main/)下载所需DCU版本安装包

```
export PYTHON3_LIB_PATH=/python_lib_path
virtualenv -p /python_bin_path/python3 --system-site-packages venv_gpt2
source env.sh	#进入venv_gpt2虚拟环境

pip install -r requirements.txt  -i http://pypi.tuna.tsinghua.edu.cn/simple  --trusted-host pypi.tuna.tsinghua.edu.cn
```

```
rm megatron/arguments.py
cp megatron/arguments.py-nodes megatron/arguments.py
sbatch  run-16B.sh(主要参数在single-16B.sh)
```

```
#重要参数
MODEL_NAME 					模型名（自定义）
CHECKPOINT_PATH				模型保存&加载路径
DATA_PATH					数据集路径（转换后的）
TENSORBOARD_PATH			tensorboard路径
CODECARBON_PATH				codecarbon路径


TP_SIZE  	 				TP数量
PP_SIZE      				PP数量
MICRO_BATCH_SIZE			MICRO_BATCH_SIZE大小
GLOBAL_BATCH_SIZE           GLOBAL_BATCH_SIZE大小
NLAYERS 					层数
NHIDDEN						隐藏层维度
NHEADS						注意力机制头数
SEQ_LEN						最大长度
SAVE_INTERVAL				保存频率

--train-samples				训练样本数
--eval-interval				验证频率
--eval-iters				验证iter
```

### 性能和收敛性

|   卡数    | 性能（samples per second） | 收敛性lm loss value | 收敛性lm loss PPL |
| :-------: | :------------------------: | :-----------------: | :---------------: |
| 32 x 4DCU |           2.449            |    4.299443E+00     |   7.365877E+01    |



## GPT2文本生成

使用GPT做文本生成时需要对训练好的模型进行转换，转换需要安装0.7.3版本 deepspeed（此工程已包含）

```
pip install deepspeed-0.7.3+unknown-cp37-cp37m-linux_x86_64.whl -i http://pypi.tuna.tsinghua.edu.cn/simple  --trusted-host pypi.tuna.tsinghua.edu.cn
```

对deepspeed进行一些修改

```
修改/usr/local/lib/python3.7/site-packages/deepspeed/checkpoint/constants.py
第34行
	ZERO_FILE_PREFIX = 'bf16_' + 'zero_pp_rank_'
改为：
	ZERO_FILE_PREFIX =  'zero_pp_rank_'

修改/usr/local/lib/python3.7/site-packages/deepspeed/ops/op_builder/builder.py
第133行 def assert_torch_info(torch_info):函数
删除下边的版本判断
	install_torch_version = torch_info['version']
	install_cuda_version = torch_info['cuda_version']
	install_hip_version = torch_info['hip_version']

修改/usr/local/lib/python3.7/site-packages/deepspeed/runtime/state_dict_factory.py文件
第177行def check_ckpt_list(self):函数
删除mp_world_size判断
	if 'mp_world_size' in sd.keys():
            assert len(self.ckpt_list) == sd['mp_world_size'], f"checkpoint count {len(self.ckpt_list)} is different from saved mp_world_size {sd['mp_world_size']}"

```

### 转换脚本

```
sh conver.sh
```

```
#重要参数
需要将工程路径加入PYTHONPATH
例如：export PYTHONPATH=/home/megatron-deepspeed_dtk22.10:$PYTHONPATH

CHECKPOINT_PATH  需要转换的模型路径(具体到保存的global_step)
output_folder	 转换后的模型路径
target_tp		 转换后的TP数（需要与训练时保持一致） 	 
target_pp		 转换后的PP数 （设置为1）
```

### 无条件文本生成

```
sh run-inf.sh（这里以单节点小模型为例）
```

```
#生成时模型各项参数需要与训练时保持一致（TP也需要保持一致）
--micro-batch-size  	micro-batch-size大小
--out-seq-length		输出文本程度
--genfile				生成文本保存位置
--num-samples			生成样本个数
```



## loss收敛情况

15B模型使用oscar数据集收敛情况如下：



![image-20230524143710566](image-gpt-loss.png)

![image-20230524143830580](image-gpt-loss2.png)

## 源码仓库及问题反馈

https://developer.hpccube.com/codes/modelzoo/gpt2-pytorch/

## 参考

https://github.com/bigscience-workshop/Megatron-DeepSpeed
