# gme-Qwen2-VL

## 论文

`GME:Improving Universal Multimodal Retrieval by Multimodal LLMs`

* https://arxiv.org/pdf/2412.16855

## 模型结构
该模型基于Qwen2-VL系列MLLM，包含视觉编码器、文本编码器和跨模态投影模块。

视觉编码器：采用类似ViT的结构，将图像分块编码为视觉token序列，并限制每张图像最多生成1024个视觉token以平衡效率与性能。

文本编码器：基于Transformer架构，支持长文本输入（最大长度1800 token）。

跨模态投影层：将视觉token与文本token对齐到统一的语义空间。

![alt text](readme_imgs/arch.png)

## 算法原理

算法采用对比学习，输入可以是文本，图像或文本-图像对。

![alt text](readme_imgs/alg.png)

## 环境配置

### Docker（方法一）
    
    docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.4.1-ubuntu22.04-dtk25.04-py3.10

    docker run --shm-size 100g --network=host --name=gme --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v 项目地址(绝对路径):/home/ -v /opt/hyhal:/opt/hyhal:ro -it <your IMAGE ID> bash

    pip install -r requirements.txt


### Dockerfile（方法二）

    docker build -t <IMAGE_NAME>:<TAG> .

    docker run --shm-size 100g --network=host --name=gme --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v 项目地址(绝对路径):/home/ -v /opt/hyhal:/opt/hyhal:ro -it <your IMAGE ID> bash
    
    pip install -r requirements.txt


### Anaconda（方法三）

1、关于本项目DCU显卡所需的特殊深度学习库可从光合开发者社区下载安装： https://developer.hpccube.com/tool/

```
DTK驱动: dtk25.04
python: python3.10
torch: 2.4.1
torchvision: 0.19.1
```

2、其他

```bash
pip install -r requirements.txt
```

## 数据集

无

## 训练

无

## 推理

```bash
python gme_inference.py
```

注意：运行前请在文件中修改相应参数。

## result

![alt text](readme_imgs/result.png)

### 精度

无

## 应用场景

### 算法类别

`多模态`

### 热点应用行业

`电商,教育,交通,能源`

## 预训练权重

|model|save_path|url|
|:---:|:---:|:---:|
|gme-Qwen2-VL-2B-Instruct|ckpts/gme-Qwen2-VL-2B-Instruct|[hf](https://huggingface.co/Alibaba-NLP/gme-Qwen2-VL-2B-Instruct) \| [SCNet](http://113.200.138.88:18080/aimodels/alibaba-nlp/gme-Qwen2-VL-2B-Instruct) |
|gme-Qwen2-VL-7B-Instruct|ckpts/gme-Qwen2-VL-7B-Instruct|[hf](https://huggingface.co/Alibaba-NLP/gme-Qwen2-VL-7B-Instruct) \| [SCNet](http://113.200.138.88:18080/aimodels/alibaba-nlp/gme-Qwen2-VL-7B-Instruct) |

## 源码仓库及问题反馈

* https://developer.sourcefind.cn/codes/modelzoo/gme-qwen2-vl_pytorch
## 参考资料

* https://huggingface.co/Alibaba-NLP/gme-Qwen2-VL-2B-Instruct
