# GLM130B_FT

## 模型介绍
GLM-130B是一个开放的双语（中英）双向密集模型，具有130亿个参数，使用[通用语言模型（GLM）](https://aclanthology.org/2022.acl-long.26)算法进行预训练。

本项目主要针对GLM-130B模型在8卡32G显存的DCU平台利用fastertransformer进行快速推理。

## 模型结构

GLM是一个基于transformer的语言模型，利用自回归空白填充作为其训练目标。

## 模型推理

### 下载镜像

在光源可拉取推理的docker镜像，拉取方式如下：

```
docker pull image.sourcefind.cn:5000/dcu/admin/base/custom:glm-ft-v1.0
```

### 编译方法

```
mkdir build
cd build
cmake -DSM=62 -DCMAKE_BUILD_TYPE=Release -DBUILD_MULTI_GPU=ON -DCMAKE_CXX_COMPILER=nvcc ..
make

#编译到100%时如果“Linking CUDA executable ../../bin/test_logprob_kernels”报错则执行如下命令
cd tests/unittests
nvcc CMakeFiles/test_logprob_kernels.dir/test_logprob_kernels.cu.o -o ../../bin/test_logprob_kernels   -L/usr/local/mpi/lib  -Wl,-rpath,/usr/local/mpi/lib -lcublas -lcublasLt -lcudart ../../lib/liblogprob_kernels.a ../../lib/libmemory_utils.a  -L"/opt/dtk-23.04/cuda/targets/x86_64-linux/lib/stubs" -L"/opt/dtk-23.04/cuda/targets/x86_64-linux/lib" -lcudart -lrt -lpthread -ldl

```

### 模型下载

从[这里](https://docs.google.com/forms/d/e/1FAIpQLSehr5Dh_i3TwACmFFi8QEgIVNYGmSPwV0GueIcsUev0NEfUug/viewform?usp=sf_link)下载GLM-130B的模型，确保所有60个块都已完全下载，然后使用以下命令将它们合并到单个存档文件中并解压缩它：

```
cat glm-130b-sat.tar.part_* > glm-130b-sat.tar
tar xvf glm-130b-sat.tar
```

模型转换

```
python ../examples/cpp/glm/glm_weight_convt.py -i /home/glm-130b-sat/49300/ -o  /home/glm-130b-sat-ft-model/
```

### 运行示例程序

生成gemm_config.in文件

```
# ./bin/gpt_gemm <batch_size> <beam_width> <max_input_len> <head_number> <size_per_head> <inter_size> <vocab_size> <data_type> <tensor_para_size>
./bin/gpt_gemm 1 1 128 96 128 49152 150528 1 8
```

修改../examples/cpp/glm/glm_config.ini配置文件

执行glm_example执行命令

```
mpirun -n 8 --allow-run-as-root ./bin/glm_example
```

此example程序会读取../examples/cpp/glm/start_ids.csv文件中的id作为输入token，生成的结果tokenid会保存在./out内，可以执行如下命令进行解析out结果：

```
python ../examples/pytorch/glm/glm_tokenize.py
```



## 源码仓库及问题反馈

[ModelZoo / GLM130B_FT · GitLab (hpccube.com)](https://developer.hpccube.com/codes/modelzoo/glm130b_ft)

## 参考

[THUDM/GLM-130B: GLM-130B: An Open Bilingual Pre-Trained Model (ICLR 2023) (github.com)](https://github.com/THUDM/GLM-130B)

[THUDM/FasterTransformer: Transformer related optimization, including BERT, GPT (github.com)](https://github.com/THUDM/FasterTransformer)