/*
 * Copyright (c) 2020-2021, NVIDIA CORPORATION.  All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#pragma once

#ifndef TORCH_TRAITS_H_
#define TORCH_TRAITS_H_

#include "src/fastertransformer/utils/cuda_utils.h"
#include <cuda_fp16.h>

using namespace fastertransformer;
namespace torch_ext {
template<typename T>
class THTraits;

template<>
class THTraits<float> {
public:
    static const OperationType OpType = OperationType::FP32;
};

template<>
class THTraits<half> {
public:
    static const OperationType OpType = OperationType::FP16;
};

}  // namespace torch_ext
#endif
