# GLM-Z1
## 论文
暂无

## 模型结构
基于transformer结构
<div align=center>
    <img src="./doc/transformers.jpg"/>
</div>

## 算法原理
GLM-Z1-32B-0414 是具有深度思考能力的推理模型，这是在 GLM-4-32B-0414 的基础上，通过冷启动和扩展强化学习，以及在数学、代码和逻辑等任务上对模型的进一步训练得到的。相对于基础模型，GLM-Z1-32B-0414 显著提升了数理能力和解决复杂任务的能力。在训练的过程中，引入了基于对战排序反馈的通用强化学习，进一步增强了模型的通用能力。

GLM-Z1-Rumination-32B-0414 是具有沉思能力的深度推理模型（对标 Open AI 的 Deep Research）。不同于一般的深度思考模型，沉思模型通过更长时间的深度思考来解决更开放和复杂的问题（例如：撰写两个城市AI发展对比情况，以及未来的发展规划），沉思模型在深度思考过程中结合搜索工具处理复杂任务，并经过利用多种规则型奖励来指导和扩展端到端强化学习训练得到。Z1-Rumination 在研究型写作和复杂检索任务上的能力得到了显著提升。

最后，GLM-Z1-9B-0414 是一个惊喜。沿用上述一系列技术，训练了一个保持开源传统的 9B 小尺寸模型。尽管规模更小，GLM-Z1-9B-0414 在数学推理和通用任务中依然展现出极为优秀的能力，其整体表现已处于同尺寸开源模型中的领先水平。特别是在资源受限的场景下，该模型在效率与效果之间实现了出色的平衡，为追求轻量化部署的用户提供了强有力的选择。

效果展示
<div align=center>
    <img src="./doc/Bench-Z1-9B.png"/>
    <img src="./doc/Bench-Z1-32B.png"/>
</div>

## 环境配置
`-v 路径`、`docker_name`和`imageID`根据实际情况修改

### Docker（方法一）
```bash
dcoker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.4.1-ubuntu22.04-dtk25.04-py3.10
docker run -it --shm-size 200g --network=host --name {docker_name} --privileged --device=/dev/kfd --device=/dev/dri --device=/dev/mkfd --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -u root -v /path/your_code_data/:/path/your_code_data/ -v /opt/hyhal/:/opt/hyhal/:ro {imageID} bash

cd /your_code_path/glm-z1_pytorch
pip install transformers>=4.51.3
```

### Dockerfile（方法二）
```bash
cd docker
docker build --no-cache -t glm4-z1:latest .
docker run -it --shm-size 200g --network=host --name {docker_name} --privileged --device=/dev/kfd --device=/dev/dri --device=/dev/mkfd --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -u root -v /path/your_code_data/:/path/your_code_data/ -v /opt/hyhal/:/opt/hyhal/:ro {imageID} bash

cd /your_code_path/glm-z1_pytorch
pip install transformers>=4.51.3
```

### Anaconda（方法三）
关于本项目DCU显卡所需的特殊深度学习库可从[光合](https://developer.sourcefind.cn/tool/)开发者社区下载安装。
```bash
DTK: 25.04
python: 3.10
torch: 2.4.1
deepspeed: 0.14.2+das.opt2.dtk2504
```
`Tips：以上dtk驱动、python、torch等DCU相关工具版本需要严格一一对应`

其它非深度学习库安装方式如下：
```bash
pip install transformers>=4.51.3
```

## 数据集
无

## 训练
### Llama Factory 微调方法(推荐)

1. 训练库安装（**非glm-z1_pytorch目录下**），安装版本**大于 v0.9.2**，`Llama-Factory`具体安装方法请参考仓库的README。
```
git clone https://developer.sourcefind.cn/codes/OpenDAS/llama-factory
```

2. 通过[预训练权重](#预训练权重)下载预训练模型，当前用例使用[GLM-Z1-9B-0414](https://huggingface.co/THUDM/GLM-Z1-9B-0414)模型。

#### 全参微调

SFT训练脚本示例，参考`llama-factory/train_full`下对应yaml文件。

**参数修改**：
- **--model_name_or_path**: 修改为待训练模型地址，如 `/data/GLM-Z1-9B-0414`
- **--dataset**: 微调训练集名称，可选数据集请参考 `llama-factory/data/dataset_info.json`
- **--template**: 将 default 修改为 `glm4`
- **--output_dir**: 模型保存地址

其他参数如：`--learning_rate`、`--save_steps`可根据自身硬件及需求进行修改。

#### lora微调

SFT训练脚本示例，参考`llama-factory/train_lora`下对应yaml文件。
参数解释同[#全参微调](#全参微调)

## 推理
### transformers推理方法
```bash
## 必须添加HF_ENDPOINT环境变量
export HF_ENDPOINT=https://hf-mirror.com

python infer_transformers.py --model_path THUDM/GLM-Z1-9B-0414
```

## result
<div align=center>
    <img src="./doc/transformers_results.png"/>
</div>

### 精度
暂无

## 应用场景
### 算法类别
对话问答

### 热点应用行业
制造,广媒,家居,教育

## 预训练权重
- [GLM-Z1-9B-0414](https://huggingface.co/THUDM/GLM-Z1-9B-0414)
- [GLM-Z1-32B-0414](https://huggingface.co/THUDM/GLM-Z1-32B-0414)

## 源码仓库及问题反馈
- https://developer.sourcefind.cn/codes/modelzoo/glm-z1_pytorch

## 参考资料
- https://github.com/THUDM/GLM-4
