# GLM-ASR-Nano
## 论文
`暂无`

## 模型简介
**GLM-ASR-Nano-2512** 是一款鲁棒的开源语音识别模型，参数量为 **1.5B**。
该模型专为应对真实世界的复杂场景而设计，在多项基准测试中超越 OpenAI Whisper V3，同时保持紧凑的模型规模。

核心能力包括：

- **卓越的方言支持**
  除标准普通话和英语外，模型针对**粤语**及其他方言进行了深度优化，有效填补了方言语音识别领域的空白。

- **低音量语音鲁棒性**
  专门针对**"低语/轻声"**场景进行训练，能够捕捉并准确转录传统模型难以识别的极低音量音频。

- **SOTA 性能**
  在同类开源模型中实现**最低平均错误率 (4.10)**，在中文基准测试（Wenet Meeting、Aishell-1 等）中展现出显著优势。

<div align=center>
    <img src="./doc/bench.png"/>
</div>

## 环境依赖

| 软件 | 版本 |
| :------: | :------: |
| DTK | 25.04.2 |
| python | 3.10.12 |
| transformers | 5.0.0.dev0 |
| fastpt | 2.1.1+das.dtk25042 |
| torch | 2.5.1+das.opt1.dtk25042 |
| torchaudio | 2.5.1+das.opt1.dtk25042 |

推荐使用镜像: harbor.sourcefind.cn:5443/dcu/admin/base/vllm:0.9.2-ubuntu22.04-dtk25.04.2-tx-1226-das1.7-py3.10-20251226

- 挂载地址`-v`根据实际模型情况修改

```bash
docker run -it \
    --shm-size 60g \
    --network=host \
    --name glm-asr-nano \
    --privileged \
    --device=/dev/kfd \
    --device=/dev/dri \
    --device=/dev/mkfd \
    --group-add video \
    --cap-add=SYS_PTRACE \
    --security-opt seccomp=unconfined \
    -u root \
    -v /opt/hyhal/:/opt/hyhal/:ro \
    -v /path/your_code_data/:/path/your_code_data/ \
    harbor.sourcefind.cn:5443/dcu/admin/base/vllm:0.9.2-ubuntu22.04-dtk25.04.2-tx-1226-das1.7-py3.10-20251226 bash
```
更多镜像可前往[光源](https://sourcefind.cn/#/service-list)下载使用。

关于本项目DCU显卡所需的特殊深度学习库可从[光合](https://developer.sourcefind.cn/tool/)开发者社区下载安装，其它包参照requirements.txt安装：

```bash
pip install -r requirements.txt
sudo apt update && sudo apt upgrade -y
apt install ffmpeg
source fastpt -E  # torchaudio 所需环境，不执行会报错 OSError: libtorch_cuda.so: cannot open shared object file: No such file or directory
```

## 数据集
`暂无`

## 训练
`暂无`

## 推理
### transformers
#### 单机推理
- repo_id: 模型实际地址，当前默认为 `ZhipuAI/GLM-ASR-Nano-2512`，根据实际情况修改
- audio_url: 测试音频文件地址，当前模型为 `examples/example_zh.wav`, 根据实际情况修改

```bash
python inference.py
```

## 效果展示

<div align=center>
    <img src="./doc/result.png"/>
</div>

### 精度
`DCU与GPU精度一致，推理框架：pytorch。`

## 预训练权重
| 模型名称  | 权重大小  | DCU型号  | 最低卡数需求 |下载地址|
|:-----:|:----------:|:----------:|:---------------------:|:----------:|
| GLM-ASR-Nano-2512 | 1.5B | BW1000 | 1 | [Modelscope](https://modelscope.cn/models/ZhipuAI/GLM-ASR-Nano-2512) |

## 源码仓库及问题反馈
- https://developer.sourcefind.cn/codes/modelzoo/glm-asr-nano_pytorch

## 参考资料
- https://github.com/zai-org/GLM-ASR
