## GLM-5
## 论文
[GLM-5: From Vibe Coding to Agentic Engineering](https://z.ai/blog/glm-5)

## 模型简介
作为智谱AI新一代旗舰大模型，GLM-5专注于复杂系统工程和长周期智能体任务。扩展模型规模仍是提升通用人工智能（AGI）智能效率的最重要途径之一。与 GLM-4.5 相比，GLM-5 的参数量从 355B（激活参数 32B）扩展至 744B（激活参数 40B），预训练数据量也从 23T tokens 增加到 28.5T tokens。此外，GLM-5 还集成了 DeepSeek 稀疏注意力（DSA）机制，在保持长上下文能力的同时大幅降低了部署成本。

## 环境依赖
| 软件 | 版本 |
| :------: | :------: |
|     DTK      |  26.04.2  |
|    python    |  3.10.12  |
| transformers |  5.2.0.dev0 |
|    torch     | 2.5.1+das.opt1.dtk2604.20260116.g78471bfd |
|     vllm     | 0.11.0+das.opt1.rc3.dtk2604 |

推荐使用镜像:harbor.sourcefind.cn:5443/dcu/admin/base/vllm:0.11.0-ubuntu22.04-dtk26.04-0130-py3.10-20260202

- 挂载地址`-v`根据实际模型情况修改

```bash
docker run -it \
    --shm-size 200g \
    --network=host \
    --name glm-5 \
    --privileged \
    --device=/dev/kfd \
    --device=/dev/dri \
    --device=/dev/mkfd \
    --group-add video \
    --cap-add=SYS_PTRACE \
    --security-opt seccomp=unconfined \
    -u root \
    -v /opt/hyhal/:/opt/hyhal/:ro \
    -v /path/your_code_data/:/path/your_code_data/ \
    harbor.sourcefind.cn:5443/dcu/admin/base/vllm:0.11.0-ubuntu22.04-dtk26.04-0130-py3.10-20260202 bash
```

更多镜像可前往[光源](https://sourcefind.cn/#/service-list)下载使用。

关于本项目DCU显卡所需的特殊深度学习库可从[光合](https://developer.sourcefind.cn/tool/)开发者社区下载安装，其它包参照requirements.txt安装：
```
pip uninstall vllm
pip install vllm-0.11.0+das.opt1.rc3.dtk2604-cp310-cp310-linux_x86_64.whl
pip install -r requirements.txt
```

## 数据集
`暂无`

## 训练
`暂无`

## 推理
### vllm
#### 多机推理
1. 加入环境变量
> 请注意：
> 每个节点上的环境变量都写到.sh文件中，保存后各个计算节点分别source`.sh`文件
>
> VLLM_HOST_IP：节点本地通信口ip，尽量选择IB网卡的IP，**避免出现rccl超时问题**
>
> NCCL_SOCKET_IFNAME和 GLOO_SOCKET_IFNAME：节点本地通信网口ip对应的名称
>
> 通信口和ip查询方法：ifconfig
>
> IB口状态查询：ibstat  !!!一定要active激活状态才可用，各个节点要保持统一

```bash
export ALLREDUCE_STREAM_WITH_COMPUTE=1
export VLLM_HOST_IP=x.x.x.x # 对应计算节点的IP，选择IB口SOCKET_IFNAME对应IP地址
export NCCL_SOCKET_IFNAME=ibxxxx
export GLOO_SOCKET_IFNAME=ibxxxx
export NCCL_IB_HCA=mlx5_0:1 # 环境中的IB网卡名字
unset NCCL_ALGO
export NCCL_MIN_NCHANNELS=16
export NCCL_MAX_NCHANNELS=16
export NCCL_NET_GDR_READ=1
export HIP_VISIBLE_DEVICES=0,1,2,3,4,5,6,7
export VLLM_SPEC_DECODE_EAGER=1
export VLLM_MLA_DISABLE=0
export VLLM_USE_FLASH_MLA=1

# K100_AI集群建议额外设置的环境变量：
export VLLM_ENFORCE_EAGER_BS_THRESHOLD=44
export VLLM_RPC_TIMEOUT=1800000

# 海光CPU绑定核
export VLLM_NUMA_BIND=1
export VLLM_RANK0_NUMA=0
export VLLM_RANK1_NUMA=1
export VLLM_RANK2_NUMA=2
export VLLM_RANK3_NUMA=3
export VLLM_RANK4_NUMA=4
export VLLM_RANK5_NUMA=5
export VLLM_RANK6_NUMA=6
export VLLM_RANK7_NUMA=7
```

2. 启动RAY集群
> x.x.x.x 对应第一步 VLLM_HOST_IP

```bash
# head节点执行
ray start --head --node-ip-address=x.x.x.x --port=6379 --num-gpus=8 --num-cpus=32
# worker节点执行
ray start --address='x.x.x.x:6379' --num-gpus=8 --num-cpus=32
```

3. 启动vllm server
```bash
vllm serve zai-org/GLM-5 \
    --port 8001 \
    --trust-remote-code \
    --tensor-parallel-size 32 \
    --gpu-memory-utilization 0.85 \
    --distributed-executor-backend ray \
    --dtype bfloat16 \
    --max-model-len 32768 \
    --speculative-config.method mtp \
    --speculative-config.num_speculative_tokens 1 \
    --tool-call-parser glm47 \
    --reasoning-parser glm45 \
    --enable-auto-tool-choice \
    --served-model-name glm-5
```

启动完成后可通过以下方式访问：
```bash
curl http://12.12.12.83:8001/v1/chat/completions   \
    -H "Content-Type: application/json"  \
    -d '{
        "model": "glm-5",
        "messages": [
          {"role": "system", "content": "You are a helpful assistant."},
          {"role": "user", "content": "Summarize GLM-5 in one sentence."}
        ],
        "max_tokens": 200,
        "temperature": 0.7
    }'
```

## 效果展示
<div align=center>
    <img src="./doc/result.png"/>
</div>

### 精度
`DCU与GPU精度一致，推理框架：vllm。`

## 预训练权重
| 模型名称  | 权重大小  | DCU型号  | 最低卡数需求 |下载地址|
|:-----:|:----------:|:----------:|:---------------------:|:----------:|
| GLM-5 | 744B | BW1000  | 32  | [Hugging Face](https://huggingface.co/zai-org/GLM-5) |

## 源码仓库及问题反馈
- https://developer.sourcefind.cn/codes/modelzoo/glm-5_vllm

## 参考资料
- https://github.com/zai-org/GLM-5
