## GLM-5

## 论文

[Qwen3-VL Technical Report](https://arxiv.org/pdf/2511.21631)

## 模型简介
- 作为智谱AI新一代旗舰大模型，GLM-5在Coding与Agent能力上取得开源 SOTA 表现，在真实编程场景的使用体感逼近Claude Opus 4.5，擅长复杂系统工程与长程Agent任务：

  

  - 参数规模从355B（激活32B）扩展至744B（激活40B），预训练数据从23T提升至28.5T，大幅提升通用智能水平；
  - 构建全新“Slime”异步强化学习框架，支持更大模型规模及更复杂强化学习任务，可通过异步智能体强化学习算法持续从长程交互中学习；
  - 首次集成DeepSeek Sparse Attention稀疏注意力机制，在维持长文本效果无损的同时，大幅降低模型部署成本、提升Token Efficiency，完全满足产业级部署需求。
<div align=center>
    <img src="./doc/qwen3vl_arc.jpg"/>
</div>

1. **Interleaved-MRoPE**: 通过稳健的位置嵌入，在时间、宽度和高度上进行全频分配，增强长时程视频推理。

2. **DeepStack**: 融合多级 ViT 特征，以捕捉精细细节并增强图像与文本的对齐。

3. **Text–Timestamp Alignment:** 超越 T-RoPE，实现基于时间戳的精确事件定位，从而增强视频时间建模能力。
## 环境依赖

|     软件     |                       版本                        |
| :----------: | :-----------------------------------------------: |
|     DTK      |                      26.04.2                      |
|    python    |                      3.10.12                      |
| transformers |                      4.57.6                       |
|    torch     |              2.5.1+das.opt1.dtk2604.20260116.g78471bfd              |
|  accelerate  |                      1.12.0                       |
| torchvision  |             0.20.1+das.opt1.dtk2604.20260116.g65c66897              |
|  flash_attn  |              2.6.1+das.opt1.dtk2504               |
|     vllm     | 0.11.0+das.opt1.alpha.dtk25042.20251225.gca4598a4 |

推荐使用镜像:harbor.sourcefind.cn:5443/dcu/admin/base/vllm:0.11.0-ubuntu22.04-dtk25.04.2-1226-das1.7-py3.10-20251226

- 挂载地址`-v`根据实际模型情况修改

```bash
docker run -it \
    --shm-size 60g \
    --network=host \
    --name qwen3 \
    --privileged \
    --device=/dev/kfd \
    --device=/dev/dri \
    --device=/dev/mkfd \
    --group-add video \
    --cap-add=SYS_PTRACE \
    --security-opt seccomp=unconfined \
    -u root \
    -v /opt/hyhal/:/opt/hyhal/:ro \
    -v /path/your_code_data/:/path/your_code_data/ \
    harbor.sourcefind.cn:5443/dcu/admin/base/vllm:0.11.0-ubuntu22.04-dtk25.04.2-1226-das1.7-py3.10-20251226
```

更多镜像可前往[光源](https://sourcefind.cn/#/service-list)下载使用。

关于本项目DCU显卡所需的特殊深度学习库可从[光合](https://developer.sourcefind.cn/tool/)开发者社区下载安装，其它包参照requirements.txt安装：

```
pip install -r requirements.txt
```

## 数据集

`暂无`

## 训练
`暂无`

## 推理

### transformers
#### 单机推理
```bash
#普通图文对话
HIP_VISIBLE_DEVICES=0 python qwen3vl_infer.py
#多图像推理
HIP_VISIBLE_DEVICES=0 python qwen3vl_infer_multi_images.py
#视频推理
HIP_VISIBLE_DEVICES=0 python qwen3vl_infer_video.py
```

## vllm

### 多机推理

1. 加入环境变量
> 请注意：
> 每个节点上的环境变量都写到.sh文件中，保存后各个计算节点分别source`.sh`文件
>
> VLLM_HOST_IP：节点本地通信口ip，尽量选择IB网卡的IP，**避免出现rccl超时问题**
>
> NCCL_SOCKET_IFNAME和 GLOO_SOCKET_IFNAME：节点本地通信网口ip对应的名称
>
> 通信口和ip查询方法：ifconfig
>
> IB口状态查询：ibstat  !!!一定要active激活状态才可用，各个节点要保持统一

```bash
export ALLREDUCE_STREAM_WITH_COMPUTE=1
export VLLM_HOST_IP=x.x.x.x # 对应计算节点的IP，选择IB口SOCKET_IFNAME对应IP地址
export NCCL_SOCKET_IFNAME=ibxxxx
export GLOO_SOCKET_IFNAME=ibxxxx
export NCCL_IB_HCA=mlx5_0:1 # 环境中的IB网卡名字
unset NCCL_ALGO
export NCCL_MIN_NCHANNELS=16
export NCCL_MAX_NCHANNELS=16
export NCCL_NET_GDR_READ=1
export HIP_VISIBLE_DEVICES=0,1,2,3,4,5,6,7
export VLLM_SPEC_DECODE_EAGER=1
export VLLM_MLA_DISABLE=0
export VLLM_USE_FLASH_MLA=1

# K100_AI集群建议额外设置的环境变量：
export VLLM_ENFORCE_EAGER_BS_THRESHOLD=44
export VLLM_RPC_TIMEOUT=1800000

# 海光CPU绑定核
export VLLM_NUMA_BIND=1
export VLLM_RANK0_NUMA=0
export VLLM_RANK1_NUMA=1
export VLLM_RANK2_NUMA=2
export VLLM_RANK3_NUMA=3
export VLLM_RANK4_NUMA=4
export VLLM_RANK5_NUMA=5
export VLLM_RANK6_NUMA=6
export VLLM_RANK7_NUMA=7
```

2. 启动RAY集群
> x.x.x.x 对应第一步 VLLM_HOST_IP

```bash
# head节点执行
ray start --head --node-ip-address=x.x.x.x --port=6379 --num-gpus=8 --num-cpus=32
# worker节点执行
ray start --address='x.x.x.x:6379' --num-gpus=8 --num-cpus=32
```
3. 启动vllm server

```bash
vllm serve Qwen/GLM-5 \
  --host x.x.x.x \
  --port 8000 \
  --distributed-executor-backend ray \
  --tensor-parallel-size 8 \
  --pipeline-parallel-size 2 \
  --trust-remote-code \
  --dtype bfloat16 \
  --max-model-len 32768 \
  --max-num-seqs 128 \
  --block-size 64 \
  --gpu-memory-utilization 0.90 \
  --allowed-local-media-path / \
  --served-model-name GLM-5
```

启动完成后可通过以下方式访问：
```bash
# /path/to/your/project 请改为图像文件存储的目录
curl http://x.x.x.x:8000/v1/chat/completions \
  -H "Content-Type: application/json" \
  -d '{
    "model": "qwen-vl",
    "messages": [
      {
        "role": "user",
        "content": [
          {
            "type": "image_url",
            "image_url": {
              "url": "file:///path/to/your/project/doc/dog.png"
            }
          },
          {
            "type": "text",
            "text": "请详细描述这张图片的内容。"
          }
        ]
      }
    ],
    "max_tokens": 512,
    "temperature": 0.7
  }'
```

## 效果展示

- image:

<div align=center>
    <img src="./doc/demo.jpeg"/>
</div>
- text: "Describe this image."

Output:

<div align=center>
    <img src="./doc/result.png"/>
</div>


### 精度

`DCU与GPU精度一致，推理框架：transformers、vllm。`

## 预训练权重



| **模型名称**                    | **权重大小** | **DCU型号** | **最低卡数需求** | **下载地址**                                  |
| :-----------------------------: | :----------: | :---------: | :--------------: | :----------------------------------------------------------: |
| **Qwen3-VL-2B-Instruct**        | 2B           | K100AI、BW1000      | 1                | [Qwen3-VL-2B-Instruct](https://huggingface.co/Qwen/Qwen3-VL-2B-Instruct) |
| **Qwen3-VL-4B-Instruct**        | 4B           | K100AI、BW1000      | 1                | [Qwen3-VL-4B-Instruct](https://huggingface.co/Qwen/Qwen3-VL-4B-Instruct) |
| **Qwen3-VL-8B-Instruct**        | 8B           | K100AI、BW1000      | 1                | [Qwen3-VL-8B-Instruct](https://huggingface.co/Qwen/Qwen3-VL-8B-Instruct) |
| **Qwen3-VL-32B-Instruct**       | 32B          | K100AI、BW1000      | 4                | [Qwen3-VL-32B-Instruct](https://huggingface.co/Qwen/Qwen3-VL-32B-Instruct) |
| **Qwen3-VL-30B-A3B-Instruct**   | 30B          | K100AI、BW1000      | 2                | [Qwen3-VL-30B-A3B-Instruct](https://huggingface.co/Qwen/Qwen3-VL-30B-A3B-Instruct) |
| **Qwen3-VL-30B-A3B-Thinking**   | 30B          | K100AI、BW1000      | 2                | [Qwen3-VL-30B-A3B-Thinking](https://huggingface.co/Qwen/Qwen3-VL-30B-A3B-Thinking) |
| **Qwen3-VL-235B-A22B-Instruct** | 235B         | K100AI、BW1000      | 8                | [Qwen3-VL-235B-A22B-Instruct](https://huggingface.co/Qwen/Qwen3-VL-235B-A22B-Instruct) |
| **Qwen3-VL-235B-A22B-Thinking** | 235B         | K100AI、BW1000      | 16               | [Qwen3-VL-235B-A22B-Thinking](https://huggingface.co/Qwen/Qwen3-VL-235B-A22B-Thinking) |





## 源码仓库及问题反馈

- https://developer.sourcefind.cn/codes/modelzoo/qwen3-vl_pytorch

## 参考资料
- https://github.com/QwenLM/Qwen3-VL
