# GLM-4.7
## 论文
[GLM-4.7 technical blog](https://z.ai/blog/glm-4.7)

## 模型简介
GLM-4.7 是智谱最新旗舰模型，GLM-4.7 面向 Agentic Coding 场景强化了编码能力、长程任务规划与工具协同，并在多个公开基准的当期榜单中取得开源模型中的领先表现。
通用能力提升，回复更简洁自然，写作更具沉浸感。在执行复杂智能体任务，在工具调用时指令遵循更强，Artifacts 与 Agentic Coding 的前端美感和长程任务完成效率进一步提升。

**核心编程：** 与前代 GLM-4.6 相比，GLM-4.7 在多语言代理编程和基于终端的任务中表现出显著提升，包括在 SWE-bench 上的 (73.8%, +5.8%)，在 SWE-bench Multilingual 上的 (66.7%, +12.9%)，以及在 Terminal Bench 2.0 上的 (41%, +16.5%)。GLM-4.7 还支持先思考后行动，在 Claude Code、Kilo Code、Cline 和 Roo Code 等主流代理框架中的复杂任务上取得了显著改进。

**氛围编程：** GLM-4.7 在提高 UI 质量方面迈出了一大步。它生成了更干净、更现代的网页，并生成了布局和尺寸更准确、外观更好的幻灯片。

**工具使用：** GLM-4.7 在工具使用方面取得了显著改进。在 τ^2-Bench 基准测试和通过 BrowseComp 进行的网页浏览方面可以看到显著更好的性能。

**复杂推理：** GLM-4.7 在数学和推理能力方面实现了重大提升，在 HLE（人类最后的考试）基准测试中相对于 GLM-4.6 取得了 (42.8%, +12.4%) 的成绩。

<div align=center>
    <img src="./doc/bench_glm47.png"/>
</div>

## 环境依赖
| 软件 | 版本 |
| :------: | :------: |
| DTK | 25.04.2 |
| python | 3.10 |
| transformers | 4.57.3 |
| vllm | 0.9.2+das.opt1.dtk25042 |
| torch | 2.5.1+das.opt1.dtk25041 |

推荐使用镜像: image.sourcefind.cn:5000/dcu/admin/base/vllm:0.9.2-ubuntu22.04-dtk25.04.2-das1.7-py3.10-20251203

- 挂载地址`-v`根据实际模型情况修改

```bash
docker run -it \
    --shm-size 60g \
    --network=host \
    --name glm-4.7 \
    --privileged \
    --device=/dev/kfd \
    --device=/dev/dri \
    --device=/dev/mkfd \
    --group-add video \
    --cap-add=SYS_PTRACE \
    --security-opt seccomp=unconfined \
    -u root \
    -v /opt/hyhal/:/opt/hyhal/:ro \
    -v /path/your_code_data/:/path/your_code_data/ \
    image.sourcefind.cn:5000/dcu/admin/base/vllm:0.9.2-ubuntu22.04-dtk25.04.2-das1.7-py3.10-20251203 bash
```
更多镜像可前往[光源](https://sourcefind.cn/#/service-list)下载使用。

关于本项目DCU显卡所需的特殊深度学习库可从[光合](https://developer.sourcefind.cn/tool/)开发者社区下载安装，其它包参照requirements.txt安装：

## 数据集
暂无

## 训练
暂无

## 推理
### vllm
#### 多机推理
1. 环境变量配置
```bash
export ALLREDUCE_STREAM_WITH_COMPUTE=1
export VLLM_HOST_IP=x.x.x.x # 对应计算节点的IP，建议选择IB口SOCKET_IFNAME对应IP地址
export HIP_VISIBLE_DEVICES=0,1,2,3,4,5,6,7
export HSA_FORCE_FINE_GRAIN_PCIE=1
export NCCL_SOCKET_IFNAME=ibxxxx
export GLOO_SOCKET_IFNAME=ibxxxx
export NCCL_IB_HCA=mlx5_0:1 # 根据 ibstat 查看
unset NCCL_ALGO
export NCCL_IB_DISABLE=0
export NCCL_MAX_NCHANNELS=16
export NCCL_MIN_NCHANNELS=16
export NCCL_NET_GDR_READ=1
export NCCL_MIN_P2P_NCHANNELS=16
export NCCL_NCHANNELS_PER_PEER=16
export HIP_USE_GRAPH_QUEUE_POOL=1
export VLLM_RPC_TIMEOUT=1800000
export VLLM_USE_FLASH_MLA=1

# 海光CPU绑定核,intel cpu可不加
export VLLM_NUMA_BIND=1
export VLLM_RANK0_NUMA=0
export VLLM_RANK1_NUMA=1
export VLLM_RANK2_NUMA=2
export VLLM_RANK3_NUMA=3
export VLLM_RANK4_NUMA=4
export VLLM_RANK5_NUMA=5
export VLLM_RANK6_NUMA=6
export VLLM_RANK7_NUMA=7
```

2. 启动RAY集群
> x.x.x.x 对应第一步 Master节点的 VLLM_HOST_IP

```bash
# head节点执行
ray start --head --node-ip-address=x.x.x.x --port=6379 --num-gpus=8 --num-cpus=32
# worker节点执行
ray start --address='x.x.x.x:6379' --num-gpus=8 --num-cpus=32
```

3. 启动vllm server
```bash
vllm serve ZhipuAI/GLM-4.7 \
    --trust-remote-code \
    --distributed-executor-backend ray \
    --dtype bfloat16 \
    --tensor-parallel-size 16 \
    --max-model-len 32768 \
    --port 8001 \
    --served-model-name glm-4.7 \
    --kv-cache-dtype auto
```

启动完成后可通过以下方式访问：
```bash
curl http://localhost:8001/v1/chat/completions   \
    -H "Content-Type: application/json"  \
    -d '{
        "model": "glm-4.7",
        "messages": [
            {
                "role": "user",
                "content": "请介绍一下你自己"
            }
        ],
        "temperature": 0.7
    }'
```

## 效果展示
<div align=center>
    <img src="./doc/result.png"/>
</div>

### 精度
DCU与GPU精度一致，推理框架：vllm。

## 预训练权重
| 模型名称  | 权重大小  | DCU型号  | 最低卡数需求 |下载地址|
|:-----:|:----------:|:----------:|:---------------------:|:----------:|
| GLM-4.7 | 358B | BW1000 | 16 | [Modelscope](https://modelscope.cn/models/ZhipuAI/GLM-4.7) |

## 源码仓库及问题反馈
- https://developer.sourcefind.cn/codes/modelzoo/glm-4.7_vllm

## 参考资料
- https://z.ai/blog/glm-4.7