# GLM-4.5-Air-Derestricted
## 论文
[GLM-4.5-Air-Derestricted](https://arxiv.org/abs/2508.06471)

## 模型简介
GLM-4.5系列模型是为智能代理设计的基础模型。GLM-4.5具有355亿个总参数，其中32亿个激活参数，而GLM-4.5-Air采用更紧凑的设计，具有106亿个总参数和12亿个活动参数。GLM-4.5模型统一了推理、编码和智能代理能力，以满足智能代理应用的复杂需求。GLM-4.5和GLM-4.5-Air都是混合推理模型，提供两种模式：用于复杂推理和工具使用的思考模式，以及用于即时响应的非思考模式。在12个行业标准基准测试中，GLM-4.5以63.2的得分在所有闭源和开源模型中位列第3。GLM-4.5-Air在保持卓越效率的同时，取得了59.8的结果。

<div align=center>
    <img src="./doc/perf.png"/>
</div>

## 环境依赖

| 软件 | 版本 |
| :------: | :------: |
| DTK | 25.04.2 |
| python | 3.10.12 |
| transformers | >=4.57.1 |
| vllm |  0.9.2+das.opt1.dtk25042 |
| torch | 2.5.1+das.opt1.dtk25042 |
| triton | 3.1+das.opt1.3c5d12d.dtk25041 |
| flash_attn | 2.6.1+das.opt1.dtk2504 |
| flash_mla | 1.0.0+das.opt1.dtk25042 |

当前仅支持镜像:
- 挂载地址`-v`根据实际模型情况修改

```bash
docker run -it --shm-size 60g --network=host --name GLM-4.5-Air-Derestricted --privileged --device=/dev/kfd --device=/dev/dri --device=/dev/mkfd --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -u root -v /opt/hyhal/:/opt/hyhal/:ro -v /path/your_code_path/:/path/your_code_path/  image.sourcefind.cn:5000/dcu/admin/base/vllm:0.9.2-ubuntu22.04-dtk25.04.2-py3.10 bash
```
更多镜像可前往[光源](https://sourcefind.cn/#/service-list)下载使用。

关于本项目DCU显卡所需的特殊深度学习库可从[光合](https://developer.sourcefind.cn/tool/)开发者社区下载安装。

## 数据集
暂无

## 训练
暂无

## 推理

### vllm
#### 单机推理
可参考vllm_serve.sh脚本
```bash
## serve启动
vllm serve ArliAI/GLM-4.5-Air-Derestricted  --trust-remote-code  --max-model-len 32768  --served-model-name glm4.5  --dtype bfloat16  -tp 4
## client访问
可参考vllm_cilent.sh
curl http://localhost:8000/v1/chat/completions  -H "Content-Type: application/json"   -d '{
        "model": "glm4.5",
        "messages": [
            {
                "role": "user",
                "content": "请介绍下你自己"
            }
            ]
    }'
```

## 效果展示
<div align=center>
    <img src="./doc/result.png"/>
</div>

### 精度
DCU与GPU精度一致，推理框架：vllm。

## 预训练权重
| 模型名称  | 权重大小  | DCU型号  | 最低卡数需求 |下载地址|
|:-----:|:----------:|:----------:|:---------------------:|:----------:|
| GLM-4.5-Air-Derestricted | 10B | K100AI | 4 | [下载地址](https://modelscope.cn/models/ArliAI/GLM-4.5-Air-Derestricted) |

## 源码仓库及问题反馈
- https://developer.sourcefind.cn/codes/modelzoo/glm-4.5-air-derestricted_vllm

## 参考资料
- https://z.ai/blog/glm-4.5
