# GLM-4-Voice
多模态模型GLM-4-Voice具备情感理解能力，能够模拟不同的情绪和语调，如高兴、悲伤、生气、害怕等，实现情感表达和共鸣，能识别中国各地方言，如粤语、重庆话、北京话等直接输出语音。
## 论文
`GLM: General Language Model Pretraining with Autoregressive Blank Infilling`
- https://aclanthology.org/2022.acl-long.26.pdf

## 模型结构
GLM-4Voice 由三个部分组成：
- GLM-4-Voice-Tokenizer: 通过在 Whisper 的 Encoder 部分增加 Vector Quantization 并在 ASR 数据上有监督训练，将连续的语音输入转化为离散的 token。
- GLM-4-Voice-Decoder: 基于 CosyVoice 的 Flow Matching 模型结构训练的支持流式推理的语音解码器，将离散化的语音 token 转化为连续的语音输出。
- GLM-4-Voice-9B: 在 GLM-4-9B 的基础上进行语音模态的预训练和对齐，从而能够理解和生成离散化的语音 token。
<div align=center>
    <img src="./doc/architecture.png"/>
</div>

## 算法原理
不同于ASR + LLM + TTS级联方案，GLM-4-Voice 采用Speech2Speech方案，以离散Token的方式表示音频，实现了音频的输入和输出的端到端建模，语音识别（ASR）模型以有监督方式训练音频Tokenizer，语音合成采用Flow Matching模型流式从音频Token合成音频，识别、合成之间的基座模型采用GLM-4-9B。

## 环境配置
```
mv glm-4-voice_pytorch GLM-4-Voice # 去框架名后缀
```

### Docker（方法一）
```
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.3.0-ubuntu22.04-dtk24.04.2-py3.10
# <your IMAGE ID>为以上拉取的docker的镜像ID替换，本镜像为：83714c19d308
docker run -it --shm-size=64G -v $PWD/GLM-4-Voice:/home/GLM-4-Voice -v /opt/hyhal:/opt/hyhal:ro --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video --name glm4v <your IMAGE ID> bash
cd /home/GLM-4-Voice
pip install -r requirements.txt # requirements.txt
# 安装ffmpeg
apt update
apt-get install ffmpeg
# 安装Matcha-TTS
cd third_party/Matcha-TTS
pip install . # matcha-tts==0.0.7.0
# 安装gradio
pip install gradio==5.4.0 # gradio
cp -r frpc_linux_amd64 /usr/local/lib/python3.10/site-packages/gradio/frpc_linux_amd64_v0.3
chmod +x /usr/local/lib/python3.10/site-packages/gradio/frpc_linux_amd64_v0.3
```
### Dockerfile（方法二）
```
cd GLM-4-Voice/docker
docker build --no-cache -t glm4v:latest .
docker run --shm-size=64G --name glm4v -v /opt/hyhal:/opt/hyhal:ro --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video -v $PWD/../../GLM-4-Voice:/home/GLM-4-Voice -it glm4v bash
# 若遇到Dockerfile启动的方式安装环境需要长时间等待，可注释掉里面的pip安装，启动容器后再安装python库：pip install -r requirements.txt。
cd /home/GLM-4-Voice
# 安装ffmpeg
apt update
apt-get install ffmpeg
# 安装Matcha-TTS
cd third_party/Matcha-TTS
pip install . # matcha-tts==0.0.7.0
# 安装gradio
pip install gradio==5.4.0 # gradio
cp -r frpc_linux_amd64 /usr/local/lib/python3.10/site-packages/gradio/frpc_linux_amd64_v0.3
chmod +x /usr/local/lib/python3.10/site-packages/gradio/frpc_linux_amd64_v0.3
```
### Anaconda（方法三）
1、关于本项目DCU显卡所需的特殊深度学习库可从光合开发者社区下载安装：
- https://developer.hpccube.com/tool/
```
DTK驱动:dtk24.04.2
python:python3.10
torch:2.3.0
torchvision:0.18.1
torchaudio:2.1.2
triton:2.1.0
flash-attn:2.0.4
deepspeed:0.14.2
apex:1.3.0
xformers:0.0.25
```

`Tips：以上dtk驱动、python、torch等DCU相关工具版本需要严格一一对应。`

2、其它非特殊库参照requirements.txt安装
```
cd GLM-4-Voice
pip install -r requirements.txt # requirements.txt
# 安装ffmpeg
apt update
apt-get install ffmpeg
# 安装Matcha-TTS
cd third_party/Matcha-TTS
pip install . # matcha-tts==0.0.7.0
# 安装gradio
pip install gradio==5.4.0 # gradio
cp -r frpc_linux_amd64 /usr/local/lib/python3.10/site-packages/gradio/frpc_linux_amd64_v0.3
chmod +x /usr/local/lib/python3.10/site-packages/gradio/frpc_linux_amd64_v0.3
```

## 数据集
无

## 训练
无

## 推理
预训练权重目录结构：
```
GLM-4-Voice/THUDM
    ├── glm-4-voice-tokenizer
    ├── glm-4-voice-9b
    └── glm-4-voice-decoder
```
```
# 1、首先启动server服务
nohup python model_server.py & # 启动模型后台运行
# 2、然后启动web服务
python web_demo.py # 在浏览器打开gradio提供的带"live"的链接
```
更多资料可参考源项目的[`README_origin`](./README_origin.md)

## result
在Input Mode处选择text格式（对audio格式感兴趣可自行试用项目中的q1.wav）：

`输入: `
```
用轻柔的声音引导我放松
```
点击"Submit"进行计算：

`输出:`
<div align=center>
    <img src="./doc/result.png"/>
</div>

### 精度
DCU与GPU精度一致，推理框架：pytorch。

## 应用场景
### 算法类别
`对话问答`
### 热点应用行业
`制造,广媒,金融,能源,医疗,家居,教育`
## 预训练权重
预训练权重快速下载中心：[SCNet AIModels](http://113.200.138.88:18080/aimodels) ，项目中的预训练权重可从快速下载通道下载：[THUDM/glm-4-voice-tokenizer](http://113.200.138.88:18080/aimodels/thudm/glm-4-voice-tokenizer.git) 、[THUDM/glm-4-voice-9b](http://113.200.138.88:18080/aimodels/thudm/glm-4-voice-9b.git)、[THUDM/glm-4-voice-decoder](http://113.200.138.88:18080/aimodels/thudm/glm-4-voice-decoder.git)。

Hugging Face下载地址为：[THUDM/glm-4-voice-tokenizer](https://huggingface.co/THUDM/glm-4-voice-tokenizer) 、[THUDM/glm-4-voice-9b](https://huggingface.co/THUDM/glm-4-voice-9b)、[THUDM/glm-4-voice-decoder](https://huggingface.co/THUDM/glm-4-voice-decoder)。
## 源码仓库及问题反馈
- http://developer.sourcefind.cn/codes/modelzoo/glm-4-voice_pytorch.git
## 参考资料
- https://github.com/THUDM/GLM-4-Voice.git

