# Gemma-2
## 论文
[Gemma 2: Improving Open Language Models at a Practical Size](https://storage.googleapis.com/deepmind-media/gemma/gemma-2-report.pdf)

## 模型结构
Gemma 2 与第一代有许多相似之处，使用transformer decoder结构进行训练。它有 8192 Tokens 的上下文长度，并使用旋转位置嵌入 (RoPE)。在7B模型中，Gemma 2使用了multi-head attention；而在2B模型中，它使用了multi-query attention(具有num_kv_heads = 1)。这种注意力机制有助于模型在处理文本数据时更好地捕捉相关信息。
Gemma 2不使用绝对位置编码，而是在每一层前加入RoPE Embedding，并共享输入与输出层的embedding权重。这种方法提高了模型的性能，并减少了计算量。
Gemma 2将ReLU的激活替换为GeGLU的激活。GeGLU是一种基于门控线性单元(GLU)的改进技术，具有更好的性能表现。
在transformer的每一层layer的前后都进行规一化，Gemma 2使用RMSNorm作为规一化层。这种规一化策略有助于提高模型的稳定性和性能。

<div align=center>
    <img src="./docs/gemma2.jpg"/>
</div>

## 算法原理
Gemma 2是由Google推出的一系列轻量级、最先进的开放模型，旨在推动负责任的AI创新。它基于与创建Gemini模型相同的研究和技术进行构建，提供了27B（270亿）参数大小的版本，具有出色的性能和效率。与原始 Gemma 相比，Gemma 2 的主要进展有四点：

+ 滑动窗口注意力: 交替使用滑动窗口和全二次注意力以提高生成质量。
+ Logit 软上限: 通过将 logits 缩放到固定范围来防止其过度增长，从而改进训练。
+ 知识蒸馏: 利用较大的教师模型来训练较小的模型（适用于 90 亿模型）。
+ 模型合并: 将两个或多个大语言模型合并成一个新的模型。

Gemma 2 Instruct 已针对对话应用进行了优化，并使用监督微调 (SFT)、大模型蒸馏、人类反馈强化学习 (RLHF) 和模型合并 (WARP) 来提高整体性能。

## 环境配置
> Llama-Factory的安装方法请参考[README](https://developer.sourcefind.cn/codes/OpenDAS/llama-factory/-/blob/master/README.md)。
>
> -v 路径、docker_name和imageID根据实际情况修改。

### Docker（方法一）
```bash
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.1.0-ubuntu20.04-dtk24.04.2-py3.10
docker run -it -v /path/your_code_data/:/path/your_code_data/ -v /opt/hyhal/:/opt/hyhal/:ro --shm-size=80G --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video --name docker_name imageID bash

cd /your_code_path/gemma2_pytorch
pip install -r requirements.txt
```
Tips:以上dtk驱动、python、torch、vllm等DCU相关工具版本需要严格一一对应。

### Dockerfile（方法二）
```bash
docker build -t gemma2:latest .
docker run -it -v /path/your_code_data/:/path/your_code_data/ -v /opt/hyhal/:/opt/hyhal/:ro --shm-size=80G --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video --name docker_name imageID bash

cd /your_code_path/gemma2_pytorch
pip install -r requirements.txt
```

### Anaconda（方法三）
关于本项目DCU显卡所需的特殊深度学习库可从[光合](https://developer.sourcefind.cn/tool/)开发者社区下载安装。
```
DTK驱动: dtk24.04.2
python: 3.10
torch: 2.1.0
llama-factory: 0.8.3
transformers: >=4.41.2
```
`Tips：以上dtk驱动、python、torch等DCU相关工具版本需要严格一一对应`

其它非深度学习库安装方式如下：
```bash
pip install -r requirements.txt
```

## 数据集
使用Llama-Factory内置数据集进行微调训练，或者根据自身需求，按照Llama-Factory需要的[格式](https://developer.sourcefind.cn/codes/OpenDAS/llama-factory/-/blob/v0.8.3/data/README_zh.md)进行数据准备。

## 训练
使用`LLaMA-Factory-v0.8.3`微调
```bash
git clone -b v0.8.3 http://developer.sourcefind.cn/codes/OpenDAS/llama-factory.git
cd llama-factory
pip install -e .[metrics]
# 卸载当前环境的flash_attn，都则会报错版本问题
pip uninstall flash_attn
```

### 单机单卡/单机多卡
1. 参考`gemma-2_pytorch/llama-factory-v0.8.3/examples`下`train_full`、`train_lora`中提供的gemma2样例，根据实际需求修改`model_name_or_path`、`dataset`、`learning_rate`、`cutoff_len`等参数，修改好的样例放入`llama-factory`框架的`examples`下的对应目录中即可。
```bash
# train_full 样例移动
cp llama-factory-v0.8.3/examples/train_full/gemma2_full_sft_ds3.yaml /path/of/llama-factory/examples/train_full/
# train_lora 样例移动
cp llama-factory-v0.8.3/examples/train_lora/gemma2_lora_sft_ds3.yaml /path/of/llama-factory/examples/train_lora/
```

2. 执行微调命令：
```bash
cd llama-factory
# 全参增量微调样例
# 卡数和卡号根据实际情况进行指定
HIP_VISIBLE_DEVICES=0,1,2,3 FORCE_TORCHRUN=1 llamafactory-cli train examples/train_full/gemma2_full_sft_ds3.yaml
# Lora微调样例
HIP_VISIBLE_DEVICES=0,1 FORCE_TORCHRUN=1 llamafactory-cli train examples/train_lora/gemma2_lora_sft_ds3.yaml
```

## 推理
使用`transformers`框架推理。

### 单机单卡
```bash
# 指定卡号
export HIP_VISIBLE_DEVICES=0,1
# 根据实际情况修改max_new_tokens参数
python inference.py --model_path /path/of/gemma2 --max_new_tokens xxx
```

## result
- 加速卡: K100*2
- 模型：gemma-2-9b

<div align=center>
    <img src="./docs/results.png"/>
</div>

### 精度
- 模型: gemma-2-2b
- 数据: alpaca_en_demo
- 训练模式: LoRA finetune + deepspeed_stage3
- 硬件：4卡，k100/A800

在DCU/NV上训练的收敛情况：

<div align=center>
    <img src="./docs/training_loss.png"/>
    <img src="./docs/training_loss_nv.png" />
</div>

## 应用场景
### 算法类别
`对话问答`

### 热点应用行业
`科研,教育,政府,金融`

## 预训练权重
[gemma-2-2b](https://huggingface.co/google/gemma-2-2b)

[gemma-2-2b-it](https://huggingface.co/google/gemma-2-2b-it)

[gemma-2-9b](https://huggingface.co/google/gemma-2-9b)

[gemma-2-9b-it](https://huggingface.co/google/gemma-2-9b-it)

[gemma-2-27b](https://huggingface.co/google/gemma-2-27b)

[gemma-2-27b-it](https://huggingface.co/google/gemma-2-27b-it)


## 源码仓库及问题反馈
- https://developer.sourcefind.cn/codes/modelzoo/gemma-2_pytorch

## 参考资料
- https://github.com/hiyouga/LLaMA-Factory
- https://ai.google.dev/gemma?hl=zh-cn
- https://huggingface.co/collections/google/gemma-2-release-667d6600fd5220e7b967f315
