# Fun-ASR-Nano
## 论文
[Fun-ASR Technical Report](https://arxiv.org/abs/2509.12508)

## 模型简介
Fun-ASR 是通义实验室推出的一款端到端语音识别大模型。它基于数千万小时的真实语音数据训练而成，具备强大的上下文理解能力和行业适应性。支持低延迟实时转写，覆盖31种语言。在教育、金融等垂直领域表现出色，能够精准识别专业术语和行业表达，有效解决“幻觉”生成和语言混淆等问题，实现“听得清、懂得意、写得准”。

<div align=center>
    <img src="./doc/funasr-v2.png"/>
</div>

## 环境依赖

| 软件 | 版本 |
| :------: | :------: |
| DTK | 25.04.2 |
| python | 3.10.12 |
| transformers | 4.51.0 |
| fastpt | 2.1.1+das.dtk25042 |
| torch | 2.5.1+das.opt1.dtk25042 |
| torchaudio | 2.5.1+das.opt1.dtk25042 |

推荐使用镜像: harbor.sourcefind.cn:5443/dcu/admin/base/vllm:0.9.2-ubuntu22.04-dtk25.04.2-tx-1226-das1.7-py3.10-20251226

- 挂载地址`-v`根据实际模型情况修改

```bash
docker run -it \
    --shm-size 60g \
    --network=host \
    --name fun-asr-nano \
    --privileged \
    --device=/dev/kfd \
    --device=/dev/dri \
    --device=/dev/mkfd \
    --group-add video \
    --cap-add=SYS_PTRACE \
    --security-opt seccomp=unconfined \
    -u root \
    -v /opt/hyhal/:/opt/hyhal/:ro \
    -v /path/your_code_data/:/path/your_code_data/ \
    harbor.sourcefind.cn:5443/dcu/admin/base/vllm:0.9.2-ubuntu22.04-dtk25.04.2-tx-1226-das1.7-py3.10-20251226 bash
```
更多镜像可前往[光源](https://sourcefind.cn/#/service-list)下载使用。

关于本项目DCU显卡所需的特殊深度学习库可从[光合](https://developer.sourcefind.cn/tool/)开发者社区下载安装，其它包参照requirements.txt安装：

```bash
pip install -r requirements.txt
source fastpt -E  # torchaudio 所需环境，不执行会报错 OSError: libtorch_cuda.so: cannot open shared object file: No such file or directory
```

## 数据集
`暂无`

## 训练
`暂无`

## 推理
### transformers
#### 单机推理
```bash
# 使用 funasr 推理
python demo1.py
# 直接推理
python demo2.py
```

## 效果展示

<div align=center>
    <img src="./doc/results.png"/>
</div>

### 精度
`DCU与GPU精度一致，推理框架：pytorch。`

## 预训练权重
| 模型名称  | 权重大小  | DCU型号  | 最低卡数需求 |下载地址|
|:-----:|:----------:|:----------:|:---------------------:|:----------:|
| Fun-ASR-Nano-2512 | 800M | BW1000 | 1 | [Modelscope](https://modelscope.cn/models/FunAudioLLM/Fun-ASR-Nano-2512) |

## 源码仓库及问题反馈
- https://developer.sourcefind.cn/codes/modelzoo/fun-asr-nano_pytorch

## 参考资料
- https://github.com/FunAudioLLM/Fun-ASR
