# FLUX.1
## 论文

`Scaling Rectified Flow Transformers for High-Resolution Image Synthesis`

https://arxiv.org/abs/2403.03206

## 模型结构

FLUX.1 是一种多模态扩散转换器(MMDiT)文本到图像模型，在图像质量、排版、复杂提示理解和资源效率方面具有显着改进的性能。

本项目主要针对FLUX.1在DCU平台的推理性能优化，达到DCU平台较快的生成效果。

![img](docs/mmdit.png)


## 算法原理

FLUX.1 以序列 Embedding 的形式处理文本输入和视觉隐空间特征。位置编码是施加在隐空间特征的 2x2 patch 上的，随后被展开成 patch 的 Enbedding 序列。这一序列和文本的特征序列一起，被送入 MMDiT 的各个模块中去。两种特征序列被转化成相同特征维度，拼接在一起，然后送入一系列注意力机制模块和多层感知机 (MLP) 里。

为应对两种模态间的差异，MMDiT 模块使用两组不同的权重去转换文本和图像序列的特征维度。两个序列之后会在注意力操作之前被合并在一起。这种设计使得两种表征能在自己的特征空间里工作，同时也使得它们之间可以通过注意力机制从对方的特征中提取有用的信息。这种文本和图像间双向的信息流动有别于以前的文生图模型，后者的文本信息是通过 cross-attention 送入模型的，且不同层输入的文本特征均是文本编码器的输出，不随深度的变化而改变。

![img](docs/algorithm.png)

## 环境配置

### Docker（方法一）

    docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.1.0-ubuntu20.04-dtk24.04.1-py3.10

    docker run --shm-size 10g --network=host --name=flux --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v 项目地址(绝对路径):/home/ -v /opt/hyhal:/opt/hyhal:ro -it <your IMAGE ID> bash

### Dockerfile（方法二）

    docker build -t <IMAGE_NAME>:<TAG> .

    docker run --shm-size 10g --network=host --name=flux --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v 项目地址(绝对路径):/home/ -v /opt/hyhal:/opt/hyhal:ro -it <your IMAGE ID> bash

### Anaconda（方法三）
关于本项目DCU显卡所需的特殊深度学习库可从[光合](https://developer.sourcefind.cn/tool/)开发者社区下载安装。
```
DTK驱动：dtk24.04
python：python3.10
torch:2.1
torchvision: 0.16.0
deepspped: 0.12.3
```
`Tips：以上dtk驱动、python、paddle等DCU相关工具版本需要严格一一对应`

关于本项目DCU显卡所需的特殊深度学习库可从[光合](https://developer.sourcefind.cn/tool/)开发者社区下载安装。
```
conda create -n flux python=3.10

conda activate flux

cd /path/your_code_data/

pip install -r requirements.txt -i http://mirrors.aliyun.com/pypi/simple
```



## 数据集
无

## 训练
无

## 推理
### 安装diffuser和依赖

```
git clone http://developer.sourcefind.cn/codes/modelzoo/flux.1_diffusers.git
cd flux.1_diffusers
git submodule init && git submodule update

1. 安装diffusers
cd diffusers
python3 setup.py install
cd ..
```

### 模型下载
[flux.1-dev](https://huggingface.co/black-forest-labs/FLUX.1-dev)

### 运行 flux.1

```
python Flux_test.py

使用xformers计算attention：
export FLUX_USE_XFORMERS=1
python Flux_test.py
```

## result
![img](./docs/result.png)

### 精度
无

## 应用场景
### 算法类别
`以文生图`

### 热点应用行业
`绘画,动漫,媒体`

## 源码仓库及问题反馈
http://developer.sourcefind.cn/codes/modelzoo/flux.1_diffusers.git

## 参考资料
https://hf-mirror.com/black-forest-labs/FLUX.1-dev
