import json
import os.path as osp

from .auto_timer import AutoTimer, default_timer
from .migraphx_model import MIGraphXModel
from .onnx_modifier import ONNXModifier
from .pipeline_call import pipeline_call  # noqa
from .pipeline_utils import from_pretrained  # noqa
from .sdxl_upcast_vae import upcast_vae  # noqa
from .text_encoders import MIGraphXCLIPTextModel, MIGraphXCLIPTextModelWithProjection
from .modeling_t5 import MIGraphXT5EncoderModel
from .transformer_flux import MIGraphXFluxTransformer2DModel
from .unet_models import MIGraphXUNet2DConditionModel
from .vae_models import MIGraphXAutoencoderKL


with open(osp.join(osp.dirname(__file__), "default_args.json"), "r") as f:
    DEFAULT_ARGS = json.load(f)


__all__ = [
    "AutoTimer",
    "DEFAULT_ARGS",
    "MIGraphXAutoencoderKL",
    "MIGraphXCLIPTextModel",
    "MIGraphXCLIPTextModelWithProjection",
    "MIGraphXFluxTransformer2DModel",
    "MIGraphXModel",
    "MIGraphXT5EncoderModel",
    "MIGraphXUNet2DConditionModel",
    "ONNXModifier",
    "default_timer",
]
