# Fish Speech
超高度还原源音色，性能超过F5、CosySense，多种语言克隆效果炸裂！

## 论文
`无`

## 模型结构
Fish Speech利用vqgan和llama分别处理人声的相似度、文字转化成人声。
<div align=center>
    <img src="./doc/structure.png"/>
</div>

## 算法原理
先利用vqgan根据目标人声伪造出高度相似的假人声，然后将文字和假人声放到llama大模型生成对应文字的mel频谱，最后再用vqgan将生成的mel频谱解码成最终需要的人声。
<div align=center>
    <img src="./doc/algorithm.png"/>
</div>

## 环境配置
```
mv fish-speech_pytorch fish-speech # 去框架名后缀
```

### Docker（方法一）
```
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.3.0-py3.10-dtk24.04.3-ubuntu20.04
# <your IMAGE ID>为以上拉取的docker的镜像ID替换，本镜像为：b272aae8ec72
docker run -it --shm-size=64G -v $PWD/fish-speech:/home/fish-speech -v /opt/hyhal:/opt/hyhal:ro --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video --name fs <your IMAGE ID> bash
cd /home/fish-speech
sh apt.sh # 安装linux中关于音频需要的基本库，以Ubuntu为例。
pip install -r requirements.txt
```
### Dockerfile（方法二）
```
cd /home/fish-speech/docker
docker build --no-cache -t fs:latest .
docker run --shm-size=64G --name fs -v /opt/hyhal:/opt/hyhal:ro --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video -v $PWD/../../fish-speech:/home/fish-speech -it fs bash
# 若遇到Dockerfile启动的方式安装环境需要长时间等待，可注释掉里面的pip安装，启动容器后再安装python库：pip install -r requirements.txt。
cd /home/fish-speech
sh apt.sh # 安装linux中关于音频需要的基本库，以Ubuntu为例。
pip install pyaudio
```
### Anaconda（方法三）
1、关于本项目DCU显卡所需的特殊深度学习库可从光合开发者社区下载安装：
- https://developer.hpccube.com/tool/
```
DTK驱动:dtk24.04.3
python:python3.10
torch:2.3.0
torchvision:0.18.1
torchaudio:2.1.2
triton:2.1.0
vllm:0.6.2
flash-attn:2.6.1
deepspeed:0.14.2
apex:1.3.0
xformers:0.0.25
transformers:4.48.0
```

`Tips：以上dtk驱动、python、torch等DCU相关工具版本需要严格一一对应。`

2、其它非特殊库参照requirements.txt安装
```
cd /home/fish-speech
sh apt.sh # 安装linux中关于音频需要的基本库，以Ubuntu为例。
pip install -r requirements.txt
```

## 数据集
`无`

## 训练
`无`


## 推理
### 单机多卡
```
export MIOPEN_DEBUG_CONV_WINOGRAD=0 # 禁用环境变量：MIOPEN_DEBUG_CONV_WINOGRAD
# 预训练权重放入：/home/fish-speech/checkpoints/
cd /home/fish-speech
sh infer.sh
```

更多资料可参考源项目的[`README_origin`](./README_origin.md)

## result

`输入: `
```
目标人声: example.wav
text："富人优先考虑的都是利益,而穷人优先考虑的永远都是感情和面子,穷人是小心翼翼的大方,而富人却是大大方方的小气。"
```
`输出:`
```
生成人声: fake.wav
```

### 精度
DCU与GPU精度一致，推理框架：pytorch。

## 应用场景
### 算法类别
`语音合成`
### 热点应用行业
`广媒,影视,动漫,医疗,家居,教育`
## 预训练权重
Hugging Face下载地址为：[fish-speech-1.5](https://huggingface.co/fishaudio/fish-speech-1.5)
## 源码仓库及问题反馈
- http://developer.sourcefind.cn/codes/modelzoo/fish-speech_pytorch.git
## 参考资料
- https://github.com/fishaudio/fish-speech.git

