# FinQwen

FinQwen: 致力于构建一个开放、稳定、高质量的金融大模型项目，基于大模型搭建金融场景智能问答系统，利用开源开放来促进「AI+金融」。

## 论文

- 无

## 模型结构

通义金融-14B（Tongyi-Finance-14B-Chat）是针对对金融行业推出的大语言模型，基于通义千问基础模型进行行业语料增量学习，强化金融领域知识和场景应用能力，覆盖金融知识问答、文本分类、信息抽取、文本创作、阅读理解、逻辑推理、多模态、Coding等能力象限。

<div align="center">
    <img src="./imgs/transformer.jpg"/>
</div>

## 算法原理

在位置编码、FFN激活函数和normalization的实现方式上，我们也采用了目前最流行的做法， 即RoPE相对位置编码、SwiGLU激活函数、RMSNorm（可选安装flash-attention加速）。

在分词器方面，相比目前主流开源模型以中英词表为主，Tongyi-Finance-14B在Qwen-14B扩展了金融行业词汇，词表大小15万。 该词表在GPT-4使用的BPE词表cl100k_base基础上，对中文、多语言进行了优化，在对中、英、代码数据的高效编解码的基础上，对部分多语言更加友好，方便用户在不扩展词表的情况下对部分语种进行能力增强。 词表对数字按单个数字位切分。调用较为高效的tiktoken分词库进行分词。

<div align=center>
    <img src="./imgs/transformer.png"/>
</div>


## 环境配置
### Docker（方法一）
[光源](https://www.sourcefind.cn/#/service-details)拉取docker镜像的地址与使用步骤

```
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.1.0-ubuntu20.04-dtk24.04.1-py3.10

docker run -it -v /path/your_code_data/:/path/your_code_data/ -v /opt/hyhal/:/opt/hyhal/:ro --shm-size=64G --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video --name finqwen <your imageID> bash

cd /path/your_code_data/

pip install -r requirements.txt -i http://mirrors.aliyun.com/pypi/simple/ --trusted-host mirrors.aliyun.com

git clone --depth 1 https://github.com/hiyouga/LLaMA-Factory.git

cd LLaMA-Factory

pip install -e ".[torch,metrics]"
```

### Dockerfile（方法二）
```
cd /path/your_code_data/docker

docker build --no-cache -t finqwen:latest .

docker run --shm-size=64G --name finqwen -v /opt/hyhal:/opt/hyhal:ro --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video -v /path/your_code_data/:/path/your_code_data/ -it finqwen bash

git clone --depth 1 https://github.com/hiyouga/LLaMA-Factory.git

cd LLaMA-Factory

pip install -e ".[torch,metrics]"
```
### Anaconda（方法三）

关于本项目DCU显卡所需的特殊深度学习库可从[光合](https://developer.hpccube.com/tool/)开发者社区下载安装。
```
DTK驱动：dtk24.04
python：python3.10
torch:2.1
torchvision: 0.16.0
deepspped: 0.12.3
```
`Tips：以上dtk驱动、python、paddle等DCU相关工具版本需要严格一一对应`

关于本项目DCU显卡所需的特殊深度学习库可从[光合](https://developer.hpccube.com/tool/)开发者社区下载安装。
```
conda create -n finqwen python=3.10

conda activate finqwen

cd /path/your_code_data/

pip install -r requirements.txt -i http://mirrors.aliyun.com/pypi/simple

git clone --depth 1 https://github.com/hiyouga/LLaMA-Factory.git

cd LLaMA-Factory

pip install -e ".[torch,metrics]"
```

## 数据集

迷你数据集 [fingpt_sentiment](./data/fingpt_sentiment.json) 

完整数据集下载地址[fingpt_sentiment](https://huggingface.co/FinGPT)

预训练需要准备你的训练数据，需要将所有样本放到一个列表中并存入json文件中。每个样本对应一个字典，包含以下信息，示例如下所示：用于正常训练的完整数据集请按此目录结构进行制备：

```
  {
    "instruction": "描述原子的结构。",
    "input": "",
    "output": "原子是物质的基本单位，它由三种基本粒子组成：质子、中子和电子。质子和中子形成原子核，位于原子中心，核外的电子围绕着原子核运动。\n\n原子结构具有层次性。原子核中，质子带正电，中子不带电（中性）。原子核非常小且致密，占据了原子总质量的绝大部分。电子带负电，通常围绕核运动，形成若干层次，称为壳层或电子层。电子数量与质子数量相等，使原子呈电中性。\n\n电子在每个壳层中都呈规律分布，并且不同壳层所能容纳的电子数也不同。在最里面的壳层一般只能容纳2个电子，其次一层最多可容纳8个电子，再往外的壳层可容纳的电子数逐层递增。\n\n原子核主要受到两种相互作用力的影响：强力和电磁力。强力的作用范围非常小，主要限制在原子核内，具有极强的吸引作用，使核子（质子和中子）紧密结合在一起。电磁力的作用范围较大，主要通过核外的电子与原子核相互作用，发挥作用。\n\n这就是原子的基本结构。原子内部结构复杂多样，不同元素的原子核中质子、中子数量不同，核外电子排布分布也不同，形成了丰富多彩的化学世界。"
  },

```

## 训练

根据实际情况在脚本中修改权重相关路径

### 单机多卡

```
sh ds_zero3_work_dtk.sh
```

## 推理

### 单机单卡

```
python finqwen_inference.py
```
## result

### 问答

<div align=center>
    <img src="./imgs/result1.png"/>
</div>


### 精度
测试数据： [fingpt_sentiment](./data/fingpt_sentiment.json)  ，使用的加速卡:K100。

| device | train_loss | eval_loss
| :------: | :------: |  :------: | 
| K100 | 0.2362 |0.1099 |
| A800 | 0.2317 |0.1089 |



## 应用场景

### 算法类别
`对话问答`

### 热点应用行业
`金融,教育,政府`

## 预训练权重
- [TongyiFinance/Tongyi-Finance-14B-Chat](https://modelscope.cn/models/TongyiFinance/Tongyi-Finance-14B-Chat)

预训练权重快速下载中心：[SCNet AIModels](http://113.200.138.88:18080/aimodels)
项目中的预训练权重可从快速下载通道下载： [Tongyi-Finance-14B-Chat](http://113.200.138.88:18080/aimodels/Tongyi-Finance-14B-Chat)

## 源码仓库及问题反馈
- https://developer.hpccube.com/codes/modelzoo/finqwen_pytorch

## 参考资料
- [通义金融大模型-魔搭](https://modelscope.cn/organization/TongyiFinance)
- [FinQwen github](https://github.com/Tongyi-EconML/FinQwen)

