import torch
from peft import PeftModel
from transformers import AutoTokenizer, AutoModel

base_model_path = '../FinGPT/chatglm2-6b' # 可在对应模型官网进行下载模型文件，也可以直接使用huggingface的模型加载
lora_model_path = '../FinGPT/saves/FinGPT/pretrained_lora/fingpt-mt_chatglm2-6b_lora'# 本地模型预训练权重,可在 <https://huggingface.co/FinGPT>下载对应模型的预训练权重
new_model_path = '../FinGPT/FinGPT_mt_chatglm2-6b-merged' # 保存新模型的地址


# Loading the base model and tokenzier
model = AutoModel.from_pretrained(
       base_model_path, torch_dtype=torch.float16, trust_remote_code=True
    )

tokenzier = AutoTokenizer.from_pretrained(
       base_model_path, trust_remote_code=True
    )

# Loading the LoRA adapter
lora_model = PeftModel.from_pretrained(model, lora_model_path, torch_dtype=torch.float16,)

# Applying the LoRA
new_model = lora_model.merge_and_unload()

# Saving the target model to new model paths
new_model.save_pretrained(new_model_path)
tokenzier.save_pretrained(new_model_path)