#!/bin/bash
# Copyright (c) Microsoft Corporation.
# SPDX-License-Identifier: Apache-2.0

# DeepSpeed Team
OUTPUT=$1
ZERO_STAGE=$2
if [ "$OUTPUT" == "" ]; then
    OUTPUT=./output
fi
if [ "$ZERO_STAGE" == "" ]; then
    ZERO_STAGE=3
fi
mkdir -p $OUTPUT

# --data_path zeroshot/twitter-financial-news-sentiment chiapudding/kaggle-financial-sentiment \

deepspeed main.py \
   --data_path /hpcfs/users/a1232991/.cache/huggingface/datasets/chiapudding___kaggle-financial-sentiment /hpcfs/users/a1232991/.cache/huggingface/datasets/zeroshot___twitter-financial-news-sentiment \
   --data_split 10,0,0 \
   --model_name_or_path decapoda-research/llama-7b-hf \
   --per_device_train_batch_size 4 \
   --per_device_eval_batch_size 4 \
   --max_seq_len 512 \
   --learning_rate 1e-5 \
   --weight_decay 0.1 \
   --num_train_epochs 2  \
   --gradient_accumulation_steps 1 \
   --lr_scheduler_type cosine \
   --num_warmup_steps 0 \
   --seed 1234 \
   --gradient_checkpointing \
   --zero_stage $ZERO_STAGE \
   --deepspeed \
   --output_dir $OUTPUT \
   &> $OUTPUT/training.log


#    --lora_dim 128 \
#    --lora_module_name model.layers. \