# FinGPT-V1 series (Labeled by the Market)

## You can try our FinGPT v1.1 model as follows or [![Open In Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/drive/1ES-_w0iUGIQJnIGbXjU_c1ei8BsTi_uO?usp=sharing):

``` python
from peft import PeftModel, PeftConfig
from transformers import LlamaForCausalLM, LlamaTokenizerFast

# Load Models
base_model = "daryl149/llama-2-13b-chat-hf" 
peft_model = "oliverwang15/FinGPT_v11_Llama2_13B_Sentiment_Market_Feedback_LoRA_FT_8bit"
tokenizer = LlamaTokenizerFast.from_pretrained(base_model, trust_remote_code=True)
tokenizer.pad_token = tokenizer.eos_token
model = LlamaForCausalLM.from_pretrained(base_model, trust_remote_code=True, device_map = "cuda:0", load_in_8bit = True,)
model = PeftModel.from_pretrained(model, peft_model)
model = model.eval()

# Make prompts
# Please change the news to the news you want
news = 'A tinyurl link takes users to a scamming site promising that users can earn thousands of dollars by becoming a Google ( NASDAQ : GOOG ) Cash advertiser'
template = """News: '''{}'''

Instruction: Please 'ONLY' output 'one' sentiment of all the above News from {{ Severely Positive / Moderately Positive / Mildly Positive / Neutral / Mildly Negative / Moderately Negative / Severely Negative }} without other words.

Answer:
"""
prompt = template.format(mews)

# Generate results
tokens = tokenizer(prompt, return_tensors='pt', padding=True)
tokens = tokens.to(model.device)
with torch.no_grad():
  res = model.generate(**tokens, max_length=1024)
torch.cuda.empty_cache()
res_sentences = [tokenizer.decode(i, skip_special_tokens=True) for i in res]
out_text = [o.split("Answer:")[1] for o in res_sentences]
sentiment = out_text[0].strip()
print(sentiment)
# Severely Negative
```



## Ⅰ. What is FinGPT-V1 series

* FinGPT-V1 is a series of LoRA model for financial sentiment analysis whose labels are generated by the change of market (stock price). 
* You can also say these models are analyzing or predicting the market through related alternative data (news, social media, filings, etc,).

## Ⅱ. Why label by the market

* Labeling has always been a big issue in the ever-changing financial market, labeling by the market is more efficient and economic than human labor (not necessarily better).
* Human's opinion on the market is sometimes biased. Since our final goal is to analyze or predict the market, why not let the model learn directly from the market.

### Ⅲ. What do we have

| Project/Model              | Base Model    | Data Type | Market | Frequency | # of Emotions |
| -------------------------- | ------------- | --------- | ------ | --------- | ------------- |
| [FinGPT v1.0](./FinGPT_v1.0/README.md) | ChatGLM2-6B   | News      | CN     | 1 day     | 5             |
| [FinGPT v1.1](./FinGPT_v1.1/README.md) | Llama 2 - 13B | News      | US     | 1 day     | 7             |

