# FinGPT


## 论文

- [FinGPT: Open-Source Financial Large Language Models](https://arxiv.org/abs/2306.06031)




## 模型结构

###  FinGPT 生态系统
#### FinGPT 为 FinLLM 提供了一个包含五个层次的全栈框架：
1. **数据源层**: 这一层确保了全面的市场覆盖，通过实时信息捕捉解决了财务数据的时间敏感性问题。
2. **数据工程层**: 该层适用于实时 NLP 数据处理，可应对金融数据中的高时间敏感性和低信噪比等固有挑战。
3. **LLMs 层**: 该层侧重于一系列微调方法（如 LoRA），可减轻财务数据的高度动态性，确保模型的相关性和准确性。
4. **任务层**: 这一层负责执行基本任务。这些任务是 FinLLM 性能评估和交叉比较的基准。
5. **应用层**: 这一层展示了实际应用和演示，突出了 FinGPT 在金融领域的潜在能力。

* FinGPT 框架： 开源金融大型语言模型

<div align="center">
<img align="center" src=figs/FinGPT_framework_20240301.png>
</div>

* [FinGPT-FinNLP](https://github.com/AI4Finance-Foundation/FinNLP): FinNLP为所有对金融领域的法学硕士和NLP感兴趣的人提供了一个平台。在这里，我们为金融领域的 LLM 培训和微调提供了完整的管道。完整架构如下图所示。详细的代码和介绍可以在[这里](https://github.com/AI4Finance-Foundation/FinNLP)找到. 或者您可以参考 [wiki](https://ai4finance-foundation.github.io/FinNLP/)。


### FinGPT的 LLMs 层使用的开源基础模型
* 欢迎为各种特定语言的金融市场提供更多开源基础模型。

| Base Model |Pretraining Tokens|Context Length  | Model Advantages |Model Size|Experiment Results |  Applications |
|  ----  |  ----  |  ----  |   ----  |   ----  |  ----  | ----  |
| [Llama-2](https://github.com/facebookresearch/llama)|2 Trillion|4096| Llama-2 excels on English-based market data | [llama-2-7b](https://huggingface.co/meta-llama/Llama-2-7b-hf) and [Llama-2-13b](https://huggingface.co/meta-llama/Llama-2-13b-hf) | llama-2 consistently shows superior fine-tuning results  | Financial Sentiment Analysis, Robo-Advisor |
| [Falcon](https://github.com/falconry/falcon) |1,500B|2048|  Maintains high-quality results while being more resource-efficient | [falcon-7b](https://huggingface.co/tiiuae/falcon-7b) |Good for English market data  | Financial Sentiment Analysis |
| [MPT](https://github.com/mosaicml/llm-foundry) |1T|2048| MPT models can be trained with high throughput efficiency and stable convergence | [mpt-7b](https://huggingface.co/mosaicml/mpt-7b) |Good for English market data  | Financial Sentiment Analysis |
| [Bloom](https://github.com/bigscience-workshop/bigscience/tree/master/train/tr11-176B-ml#readme) |366B|2048| World’s largest open multilingual language model  | [bloom-7b1](https://huggingface.co/bigscience/bloom-7b1) |Good for English market data  | Financial Sentiment Analysis |
| [ChatGLM2](https://github.com/THUDM/ChatGLM2-6B)|1.4T  |32K |Exceptional capability for Chinese language expression| [chatglm2-6b](https://huggingface.co/THUDM/chatglm2-6b) |Shows prowess for Chinese market data  | Financial Sentiment Analysis, Financial Report Summary |
| [Qwen](https://github.com/QwenLM/Qwen-7B)|2.2T  |8k |Fast response and high accuracy| [qwen-7b](https://huggingface.co/tangger/Qwen-7B-Chat) |Effective for Chinese market data  | Financial Sentiment Analysis|
| [InternLM](https://github.com/InternLM/InternLM) |1.8T  |8k |Can flexibly and independently construct workflows |[internlm-7b](https://huggingface.co/internlm/internlm-7b) |Effective for Chinese market data  | Financial Sentiment Analysis |


## 算法原理

模型基于 [General Language Model (GLM)](https://github.com/THUDM/GLM) 架构，GLM是一种基于Transformer的语言模型，以自回归空白填充为训练目标，同时具备自回归和自编码能力。

<div align="center">
<img src="figs/GLM.png" width="550" height="200">
</div>

## 环境配置
### Docker（方法一）
```
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.1.0-ubuntu22.04-dtk23.10.1-py310 

docker run -it -v /path/your_code_data/:/path/your_code_data/ -v /opt/hyhal/:/opt/hyhal/:ro --shm-size=64G --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video --name fingpt <your imageID> bash


cd /path/your_code_data/fingpt

pip install -r requirements.txt -i http://mirrors.aliyun.com/pypi/simple/ --trusted-host mirrors.aliyun.com

pip install deepspeed-0.12.3+gitfe61783.abi0.dtk2310.torch2.1.0a0-cp310-cp310-manylinux2014_x86_64.whl
```
### Dockerfile（方法二）
```
cd /path/your_code_data/fingpt/docker

docker build --no-cache -t fingpt:latest .

docker run --shm-size=64G --name fingpt -v /opt/hyhal:/opt/hyhal:ro --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video -v /path/your_code_data/:/path/your_code_data/ -it fingpt bash

cd /path/your_code_data/fingpt

pip install deepspeed-0.12.3+gitfe61783.abi0.dtk2310.torch2.1.0a0-cp310-cp310-manylinux2014_x86_64.whl
```
### Anaconda（方法三）

关于本项目DCU显卡所需的特殊深度学习库可从[光合](https://developer.hpccube.com/tool/)开发者社区下载安装。

```
DTK驱动：dtk23.10
python：python3.10
torch: 2.1.0
torchvision: 0.16.0
apex: 1.1.0
deepspped: 0.12.3
```
```
conda create -n fingpt python=3.10

cd /path/your_code_data/fingpt

pip install -r requirements.txt -i http://mirrors.aliyun.com/pypi/simple

pip install deepspeed-0.12.3+gitfe61783.abi0.dtk2310.torch2.1.0a0-cp310-cp310-manylinux2014_x86_64.whl
```


`Tips：以上dtk驱动、python、torch、deepspeed等DCU相关工具版本需要严格一一对应`

## 数据集
 
### 指令调整数据集和模型
  
  | Datasets | Train Rows |  Test Rows |Description  |
  | --------- | ----------------- | ------------ | --------------------- |
  | [fingpt-sentiment-train](https://huggingface.co/datasets/FinGPT/fingpt-sentiment-train) | 76.8K | N/A|Sentiment Analysis Training Instructions |
  | [fingpt-finred](https://huggingface.co/datasets/FinGPT/fingpt-finred)| 27.6k | 5.11k | Financial Relation Extraction Instructions |
  | [fingpt-headline](https://huggingface.co/datasets/FinGPT/fingpt-headline) | 82.2k | 20.5k | Financial Headline Analysis Instructions|
  | [fingpt-ner](https://huggingface.co/datasets/FinGPT/fingpt-ner) | 511   | 98  | Financial Named-Entity Recognition Instructions|
  | [fingpt-fiqa_qa](https://huggingface.co/datasets/FinGPT/fingpt-fiqa_qa) | 17.1k   | N/A  | Financial Q&A Instructions|
  | [fingpt-fineval](https://huggingface.co/datasets/FinGPT/fingpt-fineval) | 1.06k   | 265  | Chinese Multiple-Choice Questions Instructions|

- [huggingface数据集下载地址] <https://huggingface.co/FinGPT> 网站提供12中不同任务的数据集用于训练


### 数据处理代码

需要训练数据转换为必要的json格式，数据格式为：
```
  {
    "instruction": "描述原子的结构。",
    "input": "",
    "output": "原子是物质的基本单位，它由三种基本粒子组成：质子、中子和电子。质子和中子形成原子核，位于原子中心，核外的电子围绕着原子核运动。\n\n原子结构具有层次性。原子核中，质子带正电，中子不带电（中性）。原子核非常小且致密，占据了原子总质量的绝大部分。电子带负电，通常围绕核运动，形成若干层次，称为壳层或电子层。电子数量与质子数量相等，使原子呈电中性。\n\n电子在每个壳层中都呈规律分布，并且不同壳层所能容纳的电子数也不同。在最里面的壳层一般只能容纳2个电子，其次一层最多可容纳8个电子，再往外的壳层可容纳的电子数逐层递增。\n\n原子核主要受到两种相互作用力的影响：强力和电磁力。强力的作用范围非常小，主要限制在原子核内，具有极强的吸引作用，使核子（质子和中子）紧密结合在一起。电磁力的作用范围较大，主要通过核外的电子与原子核相互作用，发挥作用。\n\n这就是原子的基本结构。原子内部结构复杂多样，不同元素的原子核中质子、中子数量不同，核外电子排布分布也不同，形成了丰富多彩的化学世界。"
  },
```

可以使用**data_process.py**进行数据处理
```
python data_process.py
```
项目中已提供用于试验训练的迷你数据集，训练数据目录结构如下，用于正常训练的完整数据集请按此目录结构进行制备：
```
 ── dataset
    │   ├── dataset_new
    │             ├── data-00000-of-00001.arrow
    │             ├── dataset_info.json
    │             └── state.json
    │   └── twitter-financial-news-sentiment
    │             ├── sent_dataset_meta.txt
    │             ├── sent_train.csv
    │             └── sent_valid.csv
    │   └── dataset_new.json
    │   └── dataset_new.jsonl         
    │                        
```
## 训练

根据实际情况在脚本中修改权重相关路径
### 单机多卡
```
bash multi_dcu_train.sh
```

### 单机单卡
```
bash single_dcu_train.sh
```
## 推理
**注：[FinGPT预训练模型权重下载地址](https://www.modelscope.cn/models/Wangluochao/FinGPT_ChatGLM2-6B/files)直接下载模型文件至新建文件夹'/FinGPT/FinGPT_mt_chatglm2-6b-merged'路径下进行推理。**
```
python inference_FinGPT.py
```
## result
### 多任务英语推理

<div align=center>
    <img src="./figs/multi_tasks_en.png"/>
</div>

### 单任务中文推理

<div align=center>
    <img src="./figs/single_task_cn.png"/>
</div>

### 精度
测试数据：[twitter-financial-news-sentiment](../FinGPT/dataset/dataset_new.jsonl)，使用的加速卡:V100S/K100。

根据测试结果情况填写表格：
| device | train_loss | train_runtime |eval_los |eval_runtime |
| :------: | :------: | :------: | :------: |:------: |
| V100s |  0.371248 | 4445.348 | 0.06542 | 30.5495 |
| K100 | 0.371148 | 4018.4874 | 0.06536 | 53.1593 |


## 应用场景
### 算法类别
`对话问答`
### 热点应用行业
`金融,教育,政府,科研`

## 预训练权重
  | Models | Description  | Function |
  | --------- | --------------------- |---------------- |
  | [fingpt-mt_llama2-7b_lora](https://huggingface.co/FinGPT/fingpt-mt_llama2-7b_lora)| Fine-tuned Llama2-7b model with LoRA | Multi-Task |
  | [fingpt-mt_falcon-7b_lora](https://huggingface.co/FinGPT/fingpt-mt_falcon-7b_lora)| Fine-tuned falcon-7b model with LoRA  | Multi-Task |
  | [fingpt-mt_bloom-7b1_lora](https://huggingface.co/FinGPT/fingpt-mt_bloom-7b1_lora) | Fine-tuned bloom-7b1 model with LoRA | Multi-Task |
  | [fingpt-mt_mpt-7b_lora](https://huggingface.co/FinGPT/fingpt-mt_mpt-7b_lora) | Fine-tuned mpt-7b model with LoRA | Multi-Task |
  | [fingpt-mt_chatglm2-6b_lora](https://huggingface.co/FinGPT/fingpt-mt_chatglm2-6b_lora) | Fine-tuned chatglm-6b model with LoRA | Multi-Task |
  | [fingpt-mt_qwen-7b_lora](https://huggingface.co/FinGPT/fingpt-mt_qwen-7b_lora) | Fine-tuned qwen-7b model with LoRA | Multi-Task |
  | [fingpt-sentiment_llama2-13b_lora](https://huggingface.co/FinGPT/fingpt-sentiment_llama2-13b_lora) | Fine-tuned llama2-13b model with LoRA | Single-Task |
  | [fingpt-forecaster_dow30_llama2-7b_lora](https://huggingface.co/FinGPT/fingpt-forecaster_dow30_llama2-7b_lora) | Fine-tuned llama2-7b model with LoRA | Single-Task |


- [modelscope预训练模型下载地址] <https://www.modelscope.cn/models/Wangluochao/FinGPT_ChatGLM2-6B/files>
  
  可下载带有lora后缀的预训练权重，使用本人编写的**merge_model.py**文件进行模型合并。
- [huggingface预训练模型及数据集下载地址](https://huggingface.co/FinGPT)

- [FinGPT_ChatGLM2-6B预训练模型下载地址](https://www.modelscope.cn/models/Wangluochao/FinGPT_ChatGLM2-6B/files)

## 源码仓库问题反馈
- http://developer.hpccube.com/codes/modelzoo/fingpt.git

## 参考资料
- [https://github.com/AI4Finance-Foundation/FinGPT](https://github.com/AI4Finance-Foundation/FinGPT)
- [https://github.com/AI4Finance-Foundation/FinGPT/blob/master/FinGPT_Training_LoRA_with_ChatGLM2_6B_for_Beginners.ipynb](https://github.com/AI4Finance-Foundation/FinGPT/blob/master/FinGPT_Training_LoRA_with_ChatGLM2_6B_for_Beginners.ipynb)
