<!--
 * @Author: zhuww
 * @email: zhuww@sugon.com
 * @Date: 2023-03-31 17:09:07
 * @LastEditTime: 2023-12-26 17:32:01
-->
# FASTFOLD
## 论文
- [https://arxiv.org/abs/2203.00854](https://arxiv.org/abs/2203.00854)

## 模型结构
模型基于Transformer架构,主要结构包括Evofomer(48 blocks)和Struture module(8 blocks)两个模块。

![img](./docs/alphafold2.png)

## 算法原理
FastFold通过搜索同源序列和模板进行特征构造，基于蛋白质结构预测模型,进行推理的性能优化，预测蛋白质的结构。

![img](./docs/alphafold2_1.png)

## 环境配置
提供[光源](https://www.sourcefind.cn/#/service-details)拉取推理的docker镜像：
```
docker pull image.sourcefind.cn:5000/dcu/admin/base/custom:fastfold-0.2.0-dtk23.10-v2
# <Image ID>用上面拉取docker镜像的ID替换
# <Host Path>主机端路径
# <Container Path>容器映射路径
docker run -it --name fastfold --privileged --shm-size=32G  --device=/dev/kfd --device=/dev/dri/ --cap-add=SYS_PTRACE --security-opt seccomp=unconfined --ulimit memlock=-1:-1 --ipc=host --network host --group-add video -v <Host Path>:<Container Path> <Image ID> /bin/bash
```

镜像版本依赖：
* DTK驱动：dtk23.10
* Pytorch: 1.13
* fastfold: 0.2.0
* python: python3.8


测试目录：
`/opt/docker/tests`

## 数据集
推荐使用AlphaFold2中的开源数据集，包括BFD、MGnify、PDB70、Uniclust、Uniref90等,数据集大小约3TB。数据集格式如下：
```
$DOWNLOAD_DIR/                             
    bfd/  
        bfd_metaclust_clu_complete_id30_c90_final_seq.sorted_opt_hhm.ffindex
        bfd_metaclust_clu_complete_id30_c90_final_seq.sorted_opt_hhm.ffdata 
        bfd_metaclust_clu_complete_id30_c90_final_seq.sorted_opt_cs219.ffindex                           
        ...
    mgnify/                                
        mgy_clusters_2018_12.fa
    params/                                
        params_model_1.npz
        params_model_2.npz
        params_model_3.npz
        ...
    pdb70/                                
        pdb_filter.dat
        pdb70_hhm.ffindex
        pdb70_hhm.ffdata
        ...
    pdb_mmcif/                            
        mmcif_files/
            100d.cif
            101d.cif
            101m.cif
            ...
        obsolete.dat
    pdb_seqres/                            
        pdb_seqres.txt
    small_bfd/                           
        bfd-first_non_consensus_sequences.fasta
    uniclust30/                            
        uniclust30_2018_08/
            uniclust30_2018_08_md5sum
            uniclust30_2018_08_hhm_db.index
            uniclust30_2018_08_hhm_db
            ...
    uniprot/                               
        uniprot.fasta
    uniref90/                             
        uniref90.fasta
```

我们提供了一个脚本download_all_data.sh用于下载使用的数据集和模型文件：

    ./scripts/download_all_data.sh 数据集下载目录

- 也可以通过 `SCNet` 快速下载 [alphafold](http://113.200.138.88:18080/aidatasets/project-dependency/alphafold) 。

## 推理
我们分别提供了基于Pytorch的单体和多体的推理脚本。

### 单体

    python inference.py T1024.fasta data/pdb_mmcif/mmcif_files/ \
    --output_dir ./ \
    --gpus 1 \
    --use_precomputed_alignments alignments/ \
    --param_path /data/params/params_model_1.npz  \
    --uniref90_database_path data/uniref90/uniref90.fasta \
    --mgnify_database_path data/mgnify/mgy_clusters_2018_12.fa \
    --pdb70_database_path data/pdb70/pdb70 \
    --uniclust30_database_path data/uniclust30/uniclust30_2018_08/uniclust30_2018_08 \
    --bfd_database_path data/bfd/bfd_metaclust_clu_complete_id30_c90_final_seq.sorted_opt \
    --jackhmmer_binary_path `which jackhmmer` \
    --hhblits_binary_path `which hhblits` \
    --hhsearch_binary_path `which hhsearch` \
    --kalign_binary_path `which kalign` \
    --chunk_size 4 \
    --inplace

或者使用`./inference.sh`

#### 单体推理参数说明
T1024.fasta为推理的单体序列；data修改为数据集下载目录；
`--output_dir`为输出目录；`--gpus`为使用的gpu数量；`--use_precomputed_alignments`为搜索对齐目录，可以加载已经搜索对齐的序列，若不添加则进行搜索对齐；
`--param_path`为加载单体模型路径，需要和`--model_name`保持一致,默认为model_1；`--chunk_size`为分块数量，设置为4，并且使用`--inplace`来降低显存占用；
默认不进行relax操作，若需要，添加`--relaxation`；默认不保存输出的.pkl文件，若需要，添加`--save_outputs`.


Alphafold的数据预处理需要花费大量时间，因此我们通过[ray](https://docs.ray.io/en/latest/workflows/concepts.html)加快了数据预处理工作流程。
要使用ray工作流运行推理，应将参数--enable_workflow添加到cmdline或`./inference.sh`脚本中。

### 多体
    python inference.py SUGP1.fasta data/pdb_mmcif/mmcif_files/ \
    --output_dir ./ \
    --gpus 1 \
    --use_precomputed_alignments alignments/ \
    --model_preset multimer \
    --uniref90_database_path data/uniref90/uniref90.fasta \
    --mgnify_database_path data/mgnify/mgy_clusters_2018_12.fa \
    --pdb70_database_path data/pdb70/pdb70 \
    --uniclust30_database_path data/uniclust30/uniclust30_2018_08/uniclust30_2018_08 \
    --bfd_database_path data/bfd/bfd_metaclust_clu_complete_id30_c90_final_seq.sorted_opt \
    --uniprot_database_path data/uniprot/uniprot_sprot.fasta \
    --pdb_seqres_database_path data/pdb_seqres/pdb_seqres.txt  \
    --param_path data/params/params_model_1_multimer.npz \
    --model_name model_1_multimer \
    --jackhmmer_binary_path `which jackhmmer` \
    --hhblits_binary_path `which hhblits` \
    --hhsearch_binary_path `which hhsearch` \
    --kalign_binary_path `which kalign` \
    --chunk_size 4 \
    --inplace 

或者使用`./inference_multimer.sh`

#### 多体推理参数说明
SUGP1.fasta为推理的多体序列；`--param_path`为加载多体模型路径，需要和`--model_name`保持一致，其他参数同单体推理参数说明一致.

## result
`--output_dir`目录结构如下：
```
alignments/
    <target_name>/
        bfd_uniclust_hits.a3m
        mgnify_hits.sto
        uniref90_hits.sto
        ...
{target_name}_{model_name}_output_dict.pkl
{target_name}_{model_name}_unrelaxed.pdb
{target_name}_{model_name}_relaxed.pdb
```

[查看蛋白质3D结构](https://www.pdbus.org/3d-view)
<div style="display: flex; justify-content: center; align-items: center;">
  <img src="./docs/result_pdb.png" alt="Image">
  <div style="position: absolute; top: 50%; left: 50%; transform: translate(-50%, -50%); background: rgba(0, 0, 0, 0.5); color: #fff; padding: 10px;">
    红色为真实结构，蓝色为预测结构
  </div>
</div>

## 精度
测试数据：[casp14](https://www.predictioncenter.org/casp14/targetlist.cgi)（或者通过`SCNet`快速下载[casp14](http://113.200.138.88:18080/aimodels/findsource-dependency/casp14)）、[uniprot](https://www.uniprot.org/)，使用的加速卡:1张 Z100L-32G

1、计算plddts的值

    python3 pkl2plddt.py
    其中，data_path为推理生成的pkl文件路径。


2、其它精度值计算：[https://zhanggroup.org/TM-score/](https://zhanggroup.org/TM-score/)

准确性数据：
| 数据类型 | 序列类型 | 序列标签 | 序列长度 | GDT-TS | GDT-HA | PLDDTS | TM score | MaxSub | RMSD |
| :------: | :------: | :------: | :------: |:------: |:------: | :------: | :------: | :------: |:------: |
| fp32 | 单体 | T1024  | 408  | 0.595 | 0.441 | 90.828 | 0.663 | 0.489 | 5.779 |
| fp32 | 单体 | T1053  | 580  | 0.937 | 0.782 | 92.284 | 0.984 | 0.929 | 1.105 |
| fp32 | 单体 | Q9NYK1 | 1046 | 0.907 | 0.744 | 86.642 | 0.962 | 0.905 | 5.757 |

## 应用场景

### 算法类别
NLP

### 热点应用行业
医疗,科研,教育


## 源码仓库及问题反馈
* [https://developer.hpccube.com/codes/modelzoo/fastfold_pytorch](https://developer.hpccube.com/codes/modelzoo/fastfold_pytorch)

## 参考
* [https://github.com/deepmind/alphafold](https://github.com/deepmind/alphafold)
* [https://github.com/hpcaitech/FastFold](https://github.com/hpcaitech/FastFold)
