# FastReID
## 论文
暂无

## 模型简介
FastReID 是一个研究平台，实现了最先进的重识别算法。它是对先前版本reid strong baseline的彻底重写
- 核心功能**
- **任务扩展**：从最初的ReID扩展到图像分类（FastCls）、属性识别（FastAttr）、人脸识别（FastFace）和细粒度图像检索（FastRetri）等任务 。 ‌
- **模型优化**：提供模型蒸馏、自动超参搜索、分布式训练加速等功能，支持模型导出（如Caffe/ONNX/TensorRT） 。 ‌
- **技术亮点**
- **蒸馏方法**：采用JS Div Loss优化蒸馏过程，并集成Overhaul Distillation提升性能 。 ‌
- **超参搜索**：集成Ray Tune实现Bayesian优化，支持分布式并行实验 


## 环境依赖

| 软件 | 版本 |
| :------: | :------: |
| DTK | 25.04.2 |
| python | 3.10.12 |
| transformers | 4.57.1 |
| torch | 2.5.1+das.opt1.dtk25042 |
| triton | 3.1+das.opt1.3c5d12d.dtk25041 |
| flash_attn | 2.6.1+das.opt1.dtk2504 |
| flash_mla | 1.0.0+das.opt1.dtk25042 |

当前仅支持镜像:
- 挂载地址`-v`根据实际模型情况修改

```bash
docker run -it --shm-size 60g --network=host --name minimax_m2 --privileged --device=/dev/kfd --device=/dev/dri --device=/dev/mkfd --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -u root -v /opt/hyhal/:/opt/hyhal/:ro -v /path/your_code_path/:/path/your_code_path/ image.sourcefind.cn:5000/dcu/admin/base/custom:vllm-ubuntu22.04-dtk25.04.2-py3.10-minimax-m2 bash
```
更多镜像可前往[光源](https://sourcefind.cn/#/service-list)下载使用。

关于本项目DCU显卡所需的特殊深度学习库可从[光合](https://developer.sourcefind.cn/tool/)开发者社区下载安装。

## 数据集
Market1501:[百度云盘](https://pan.baidu.com/s/1ntIi2Op)
```
datasets/
    Market-1501-v15.09.15/
        bounding_box_test/
        bounding_box_train/
```
DukeMTMC-ReID:
```
datasets/
    DukeMTMC-reID/
        bounding_box_train/
        bounding_box_test/
```
MSMT17:
```
datasets/
    MSMT17_V2/
        mask_train_v2/
        mask_test_v2/
```
## 训练

### 单卡训练
```bash
python3 tools/train_net.py --config-file ./configs/Market1501/bagtricks_R50.yml MODEL.DEVICE "cuda:0"
```
### 多卡训练
```bash
# machine 1
export GLOO_SOCKET_IFNAME=eth0
export NCCL_SOCKET_IFNAME=eth0

python3 tools/train_net.py --config-file configs/Market1501/bagtricks_R50.yml \
--num-gpus 4 --num-machines 2 --machine-rank 0 --dist-url tcp://ip:port 

# machine 2
export GLOO_SOCKET_IFNAME=eth0
export NCCL_SOCKET_IFNAME=eth0

python3 tools/train_net.py --config-file configs/Market1501/bagtricks_R50.yml \
--num-gpus 4 --num-machines 2 --machine-rank 1 --dist-url tcp://ip:port 
```


## 推理
### 推理验证
```bash
python3 tools/train_net.py --config-file ./configs/Market1501/bagtricks_R50.yml --eval-only \
MODEL.WEIGHTS /path/to/checkpoint_file MODEL.DEVICE "cuda:0"
``` 


## 效果展示
暂无

### 精度
DCU与GPU精度一致。

## 预训练权重
| reid模型  | 权重大小  | DCU型号  | 最低卡数需求 |下载地址|
|:-----:|:----------:|:----------:|:---------------------:|:----------:|
| AGW | 287MB | K100AI | 1 | https://github.com/JDAI-CV/fast-reid/blob/master/MODEL_ZOO.md

## 源码仓库及问题反馈
- https://developer.sourcefind.cn/codes/modelzoo/fast-reid_pytorch

## 参考资料
- https://github.com/JDAI-CV/fast-reid/tree/master
