# Fara
## 论文
Fara-7B [https://arxiv.org/abs/2511.19663]

## 模型简介
Fara是一个70亿参数的计算机使用代理 (CUA) 模型，专门用于在网页上执行操作以完成高级用户任务。除了理解网页布局和基本操作机制外，它还计划和执行高级目标，如预订餐厅、申请工作、规划旅行和购买购物清单。其训练依赖于由多代理管道生成并验证的大规模完全合成的动作轨迹数据集。Fara通过截图感知浏览器输入，而内部推理和状态历史则以文本形式记录。基于最近的截图和完整的动作历史，它预测下一个带有必要论据（例如点击坐标）的动作。

### 对齐方法
Fara-7B模型采用了一种基于开源与内部合成数据集的强健化后训练安全方案。该方案通过关键节点识别机制——即在需要用户授权或涉及敏感信息的场景中主动暂停操作——确保行为安全性。模型经训练能够拒绝有害任务，并经过自动化红队测试以系统评估各类风险，包括事实依据可靠性、越狱攻击防范、有害内容生成及版权合规性等维度。
### 安全措施
Fara-7B模型经过训练，能够拒绝执行违反使用政策类别的任务
| 类型 | 描述 |示例 |
| :------: | :------: | :------: |
| 非法活动 | 需要非法行为的任务 |与恐怖主义相关的搜索、盗版、未经授权的访问、武器制造 |
| 欺诈任务 | 误导或冒充的任务 |假表单、欺诈性列表、网络钓鱼 |
| 高风险/受监管领域 | 需要专业监督的任务 |医疗、法律、财务建议或批准 |
| 骚扰、剥削、仇恨 |  伤害或歧视的任务 |骚扰内容、跟踪、对未成年人进行性化 |
| 不安全的技术使用 | 自动化的滥用 |大规模抓取、垃圾邮件、系统中断 |
| 误导信息 | 散布虚假声明 |发布未经验证的声明 |
| 性相关 | 情色或色情任务 |情色角色扮演、色情搜索 |



## 环境依赖

| 软件 | 版本 |
| :------: | :------: |
| DTK | 25.04.2 |
| python | 3.10.12 |
| transformers | >=4.57.1 |
| vllm |  0.9.2+das.opt1.dtk25042 |
| torch | 2.5.1+das.opt1.dtk25042 |
| triton | 3.1+das.opt1.3c5d12d.dtk25041 |
| flash_attn | 2.6.1+das.opt1.dtk2504 |
| flash_mla | 1.0.0+das.opt1.dtk25042 |

当前仅支持镜像:
- 挂载地址`-v`根据实际模型情况修改

```bash
docker run -it --shm-size 60g --network=host --name  Fara --privileged --device=/dev/kfd --device=/dev/dri --device=/dev/mkfd --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -u root -v /opt/hyhal/:/opt/hyhal/:ro -v /path/your_code_path/:/path/your_code_path/  image.sourcefind.cn:5000/dcu/admin/base/vllm:0.9.2-ubuntu22.04-dtk25.04.2-py3.10 bash
```
更多镜像可前往[光源](https://sourcefind.cn/#/service-list)下载使用。

关于本项目DCU显卡所需的特殊深度学习库可从[光合](https://developer.sourcefind.cn/tool/)开发者社区下载安装。

## 数据集
暂无

## 训练
暂无

## 推理

### vllm
#### 单机推理
可参考vllm_serve.sh脚本
```bash
## serve启动
vllm serve microsoft/Fara-7B/  --trust-remote-code --dtype bfloat16 --max-seq-len-to-capture 32768 -tp 1   --max-model-len 32768
## client访问
可参考vllm_cilent.sh
curl http://localhost:8000/v1/chat/completions \
    -H "Content-Type: application/json" \
    -d '{
        "model": "microsoft/Fara-7B/",
        "messages": [
            {
                "role": "user",
                "content": "请介绍下自己."
                }
            ]
    }'
```

## 效果展示
<div align=center>
    <img src="./doc/result.png"/>
</div>

### 精度
DCU与GPU精度一致，推理框架：vllm。

## 预训练权重
| 模型名称  | 权重大小  | DCU型号  | 最低卡数需求 |下载地址|
|:-----:|:----------:|:----------:|:---------------------:|:----------:|
| Fara-7B | 7B | K100AI | 1 | [下载地址](https://modelscope.cn/models/microsoft/Fara-7B) |

## 源码仓库及问题反馈
- https://developer.sourcefind.cn/codes/modelzoo/fara_vllm

## 参考资料
- https://github.com/microsoft/fara
