from facechain.utils import project_dir
neg_prompt = '(nsfw:2), paintings, sketches, (worst quality:2), (low quality:2), ' \
             'lowers, normal quality, ((monochrome)), ((grayscale)), logo, word, character, bad hand, tattoo, (username, watermark, signature, time signature, timestamp, artist name, copyright name, copyright),'\
             'low res, ((monochrome)), ((grayscale)), skin spots, acnes, skin blemishes, age spot, glans, extra fingers, fewer fingers, strange fingers, bad hand, mole, ((extra legs)), ((extra hands))'
pos_prompt_with_cloth = 'raw photo, masterpiece, chinese, {}, solo, medium shot, high detail face, looking straight into the camera with shoulders parallel to the frame, photorealistic, best quality'
pos_prompt_with_style = '{}, upper_body, raw photo, masterpiece, solo, medium shot, high detail face, photorealistic, best quality'

base_models = [
    {'name': 'leosamsMoonfilm_filmGrain20',
    'model_id': 'ly261666/cv_portrait_model',
    'revision': 'v2.0',
    'sub_path': "film/film"},
    {'name': 'MajicmixRealistic_v6',
    'model_id': 'YorickHe/majicmixRealistic_v6',
    'revision': 'v1.0.0',
    'sub_path': "realistic"},
    {'name': 'sdxl_1.0',
    'model_id': 'AI-ModelScope/stable-diffusion-xl-base-1.0',
    'revision': 'v1.0.0',
    'sub_path': ""},
]

pose_models = [
    {'name': '无姿态控制(No pose control)'},
    {'name': 'pose-v1.1-with-depth'},
    {'name': 'pose-v1.1'}
]

pose_examples = {
    'man': [
        [f'{project_dir}/poses/man/pose1.png'],
        [f'{project_dir}/poses/man/pose2.png'],
        [f'{project_dir}/poses/man/pose3.png'],
        [f'{project_dir}/poses/man/pose4.png']
    ],
    'woman': [
        [f'{project_dir}/poses/woman/pose1.png'],
        [f'{project_dir}/poses/woman/pose2.png'],
        [f'{project_dir}/poses/woman/pose3.png'],
        [f'{project_dir}/poses/woman/pose4.png'],
    ]
}


tts_speakers_map = {
    '普通话(中国大陆)-Xiaoxiao-女': 'zh-CN-XiaoxiaoNeural',
    '普通话(中国大陆)-Xiaoyi-女': 'zh-CN-XiaoyiNeural',
    '普通话(中国大陆)-Yunjian-男': 'zh-CN-YunjianNeural',
    '普通话(中国大陆)-Yunxi-男': 'zh-CN-YunxiNeural',
    '普通话(中国大陆)-Yunxia-男': 'zh-CN-YunxiaNeural',
    '普通话(中国大陆)-Yunyang-男': 'zh-CN-YunyangNeural',
    '普通话(中国辽宁)-Xiaobei-女': 'zh-CN-liaoning-XiaobeiNeural',
    '普通话(中国陕西)-Xiaoni-女': 'zh-CN-shaanxi-XiaoniNeural',
    '普通话(中国台湾)-HsiaoChen-女': 'zh-TW-HsiaoChenNeural',
    '普通话(中国台湾)-HsiaoYu-女': 'zh-TW-HsiaoYuNeural',
    '普通话(中国台湾)-YunJhe-男': 'zh-TW-YunJheNeural',
    '粤语(中国香港)-HiuMaan-女': 'zh-HK-HiuMaanNeural',
    '粤语(中国香港)-HiuGaai-女': 'zh-HK-HiuGaaiNeural',
    '粤语(中国香港)-WanLung-男': 'zh-HK-WanLungNeural',
    '英语(美国)-Jenny-女': 'en-US-JennyNeural',
    '英语(美国)-Guy-男': 'en-US-GuyNeural',
    '英语(美国)-Ana-女': 'en-US-AnaNeural',
    '英语(美国)-Aria-女': 'en-US-AriaNeural',
    '英语(美国)-Christopher-男': 'en-US-ChristopherNeural',
    '英语(美国)-Eric-男': 'en-US-EricNeural',
    '英语(美国)-Michelle-女': 'en-US-MichelleNeural',
    '英语(美国)-Roger-男': 'en-US-RogerNeural',
    '英语(澳大利亚)-Natasha-女': 'en-AU-NatashaNeural',
    '英语(澳大利亚)-William-男': 'en-AU-WilliamNeural',
    '英语(加拿大)-Clara-女': 'en-CA-ClaraNeural',
    '英语(加拿大)-Liam-男': 'en-CA-LiamNeural',
    '英语(英国)-Libby-女': 'en-GB-LibbyNeural',
    '英语(英国)-Maisie-女': 'en-GB-MaisieNeural',
    '英语(英国)-Ryan-男': 'en-GB-RyanNeural',
    '英语(英国)-Sonia-女': 'en-GB-SoniaNeural',
    '英语(英国)-Thomas-男': 'en-GB-ThomasNeural',
    '英语(香港)-Sam-男': 'en-HK-SamNeural',
    '英语(香港)-Yan-女': 'en-HK-YanNeural',
    '英语(爱尔兰)-Connor-男': 'en-IE-ConnorNeural',
    '英语(爱尔兰)-Emily-女': 'en-IE-EmilyNeural',
    '英语(印度)-Neerja-女': 'en-IN-NeerjaNeural',
    '英语(印度)-Prabhat-男': 'en-IN-PrabhatNeural',
    '英语(肯尼亚)-Asilia-女': 'en-KE-AsiliaNeural',
    '英语(肯尼亚)-Chilemba-男': 'en-KE-ChilembaNeural',
    '英语(尼日利亚)-Abeo-男': 'en-NG-AbeoNeural',
    '英语(尼日利亚)-Ezinne-女': 'en-NG-EzinneNeural',
    '英语(新西兰)-Mitchell-男': 'en-NZ-MitchellNeural',
    '英语(菲律宾)-James-男': 'en-PH-JamesNeural',
    '英语(菲律宾)-Rosa-女': 'en-PH-RosaNeural',
    '英语(新加坡)-Luna-女': 'en-SG-LunaNeural',
    '英语(新加坡)-Wayne-男': 'en-SG-WayneNeural',
    '英语(坦桑尼亚)-Elimu-男': 'en-TZ-ElimuNeural',
    '英语(坦桑尼亚)-Imani-女': 'en-TZ-ImaniNeural',
    '英语(南非)-Leah-女': 'en-ZA-LeahNeural',
    '英语(南非)-Luke-男': 'en-ZA-LukeNeural',
    '韩语(韩国)-SunHi-女': 'ko-KR-SunHiNeural',
    '韩语(韩国)-InJoon-男': 'ko-KR-InJoonNeural',
    '泰语(泰国)-Premwadee-女': 'th-TH-PremwadeeNeural',
    '泰语(泰国)-Niwat-男': 'th-TH-NiwatNeural',
    '越南语(越南)-HoaiMy-女': 'vi-VN-HoaiMyNeural',
    '越南语(越南)-NamMinh-男': 'vi-VN-NamMinhNeural',
    '日语(日本)-Nanami-女': 'ja-JP-NanamiNeural',
    '日语(日本)-Keita-男': 'ja-JP-KeitaNeural',
    '法语(法国)-Denise-女': 'fr-FR-DeniseNeural',
    '法语(法国)-Eloise-女': 'fr-FR-EloiseNeural',
    '法语(法国)-Henri-男': 'fr-FR-HenriNeural',
    '法语(比利时)-Charline-女': 'fr-BE-CharlineNeural',
    '法语(比利时)-Gerard-男': 'fr-BE-GerardNeural',
    '法语(加拿大)-Sylvie-女': 'fr-CA-SylvieNeural',
    '法语(加拿大)-Antoine-男': 'fr-CA-AntoineNeural',
    '法语(加拿大)-Jean-男': 'fr-CA-JeanNeural',
    '法语(瑞士)-Ariane-女': 'fr-CH-ArianeNeural',
    '法语(瑞士)-Fabrice-男': 'fr-CH-FabriceNeural',
    '葡萄牙语(巴西)-Francisca-女': 'pt-BR-FranciscaNeural',
    '葡萄牙语(巴西)-Antonio-男': 'pt-BR-AntonioNeural',
    '葡萄牙语(葡萄牙)-Duarte-男': 'pt-PT-DuarteNeural',
    '葡萄牙语(葡萄牙)-Raquel-女': 'pt-PT-RaquelNeural',
    '意大利语(意大利)-Isabella-女': 'it-IT-IsabellaNeural',
    '意大利语(意大利)-Diego-男': 'it-IT-DiegoNeural',
    '意大利语(意大利)-Elsa-女': 'it-IT-ElsaNeural',
    '荷兰语(荷兰)-Colette-女': 'nl-NL-ColetteNeural',
    '荷兰语(荷兰)-Fenna-女': 'nl-NL-FennaNeural',
    '荷兰语(荷兰)-Maarten-男': 'nl-NL-MaartenNeural',
    '荷兰语(比利时)-Arnaud-男': 'nl-BE-ArnaudNeural',
    '荷兰语(比利时)-Dena-女': 'nl-BE-DenaNeural',
    '挪威语(挪威)-Pernille-女': 'nb-NO-PernilleNeural',
    '挪威语(挪威)-Finn-男': 'nb-NO-FinnNeural',
    '瑞典语(瑞典)-Sofie-女': 'sv-SE-SofieNeural',
    '瑞典语(瑞典)-Mattias-男': 'sv-SE-MattiasNeural',
    '希腊语(希腊)-Athina-女': 'el-GR-AthinaNeural',
    '希腊语(希腊)-Nestoras-男': 'el-GR-NestorasNeural',
    '德语(德国)-Katja-女': 'de-DE-KatjaNeural',
    '德语(德国)-Amala-女': 'de-DE-AmalaNeural',
    '德语(德国)-Conrad-男': 'de-DE-ConradNeural',
    '德语(德国)-Killian-男': 'de-DE-KillianNeural',
    '德语(奥地利)-Ingrid-女': 'de-AT-IngridNeural',
    '德语(奥地利)-Jonas-男': 'de-AT-JonasNeural',
    '德语(瑞士)-Jan-男': 'de-CH-JanNeural',
    '德语(瑞士)-Leni-女': 'de-CH-LeniNeural',
    '丹麦语(丹麦)-Christel-女': 'da-DK-ChristelNeural',
    '丹麦语(丹麦)-Jeppe-男': 'da-DK-JeppeNeural',
    '西班牙语(墨西哥)-Dalia-女': 'es-MX-DaliaNeural',
    '西班牙语(墨西哥)-Jorge-男': 'es-MX-JorgeNeural',
    '西班牙语(阿根廷)-Elena-女': 'es-AR-ElenaNeural',
    '西班牙语(阿根廷)-Tomas-男': 'es-AR-TomasNeural',
    '西班牙语(玻利维亚)-Marcelo-男': 'es-BO-MarceloNeural',
    '西班牙语(玻利维亚)-Sofia-女': 'es-BO-SofiaNeural',
    '西班牙语(哥伦比亚)-Gonzalo-男': 'es-CO-GonzaloNeural',
    '西班牙语(哥伦比亚)-Salome-女': 'es-CO-SalomeNeural',
    '西班牙语(哥斯达黎加)-Juan-男': 'es-CR-JuanNeural',
    '西班牙语(哥斯达黎加)-Maria-女': 'es-CR-MariaNeural',
    '西班牙语(古巴)-Belkys-女': 'es-CU-BelkysNeural',
    '西班牙语(多米尼加共和国)-Emilio-男': 'es-DO-EmilioNeural',
    '西班牙语(多米尼加共和国)-Ramona-女': 'es-DO-RamonaNeural',
    '西班牙语(厄瓜多尔)-Andrea-女': 'es-EC-AndreaNeural',
    '西班牙语(厄瓜多尔)-Luis-男': 'es-EC-LuisNeural',
    '西班牙语(西班牙)-Alvaro-男': 'es-ES-AlvaroNeural',
    '西班牙语(西班牙)-Elvira-女': 'es-ES-ElviraNeural',
    '西班牙语(赤道几内亚)-Teresa-女': 'es-GQ-TeresaNeural',
    '西班牙语(危地马拉)-Andres-男': 'es-GT-AndresNeural',
    '西班牙语(危地马拉)-Marta-女': 'es-GT-MartaNeural',
    '西班牙语(洪都拉斯)-Carlos-男': 'es-HN-CarlosNeural',
    '西班牙语(洪都拉斯)-Karla-女': 'es-HN-KarlaNeural',
    '西班牙语(尼加拉瓜)-Federico-男': 'es-NI-FedericoNeural',
    '西班牙语(尼加拉瓜)-Yolanda-女': 'es-NI-YolandaNeural',
    '西班牙语(巴拿马)-Margarita-女': 'es-PA-MargaritaNeural',
    '西班牙语(巴拿马)-Roberto-男': 'es-PA-RobertoNeural',
    '西班牙语(秘鲁)-Alex-男': 'es-PE-AlexNeural',
    '西班牙语(秘鲁)-Camila-女': 'es-PE-CamilaNeural',
    '西班牙语(波多黎各)-Karina-女': 'es-PR-KarinaNeural',
    '西班牙语(波多黎各)-Victor-男': 'es-PR-VictorNeural',
    '西班牙语(巴拉圭)-Mario-男': 'es-PY-MarioNeural',
    '西班牙语(巴拉圭)-Tania-女': 'es-PY-TaniaNeural',
    '西班牙语(萨尔瓦多)-Lorena-女': 'es-SV-LorenaNeural',
    '西班牙语(萨尔瓦多)-Rodrigo-男': 'es-SV-RodrigoNeural',
    '西班牙语(美国)-Alonso-男': 'es-US-AlonsoNeural',
    '西班牙语(美国)-Paloma-女': 'es-US-PalomaNeural',
    '西班牙语(乌拉圭)-Mateo-男': 'es-UY-MateoNeural',
    '西班牙语(乌拉圭)-Valentina-女': 'es-UY-ValentinaNeural',
    '西班牙语(委内瑞拉)-Paola-女': 'es-VE-PaolaNeural',
    '西班牙语(委内瑞拉)-Sebastian-男': 'es-VE-SebastianNeural',
    '俄语(俄罗斯)-Svetlana-女': 'ru-RU-SvetlanaNeural',
    '俄语(俄罗斯)-Dmitry-男': 'ru-RU-DmitryNeural',
    '阿姆哈拉语(埃塞俄比亚)-Ameha-男': 'am-ET-AmehaNeural',
    '阿姆哈拉语(埃塞俄比亚)-Mekdes-女': 'am-ET-MekdesNeural',
    '阿拉伯语(沙特阿拉伯)-Hamed-男': 'ar-SA-HamedNeural',
    '阿拉伯语(沙特阿拉伯)-Zariyah-女': 'ar-SA-ZariyahNeural',
    '阿拉伯语(阿拉伯联合酋长国)-Fatima-女': 'ar-AE-FatimaNeural',
    '阿拉伯语(阿拉伯联合酋长国)-Hamdan-男': 'ar-AE-HamdanNeural',
    '阿拉伯语(巴林)-Ali-男': 'ar-BH-AliNeural',
    '阿拉伯语(巴林)-Laila-女': 'ar-BH-LailaNeural',
    '阿拉伯语(阿尔及利亚)-Ismael-男': 'ar-DZ-IsmaelNeural',
    '阿拉伯语(埃及)-Salma-女': 'ar-EG-SalmaNeural',
    '阿拉伯语(埃及)-Shakir-男': 'ar-EG-ShakirNeural',
    '阿拉伯语(伊拉克)-Bassel-男': 'ar-IQ-BasselNeural',
    '阿拉伯语(伊拉克)-Rana-女': 'ar-IQ-RanaNeural',
    '阿拉伯语(约旦)-Sana-女': 'ar-JO-SanaNeural',
    '阿拉伯语(约旦)-Taim-男': 'ar-JO-TaimNeural',
    '阿拉伯语(科威特)-Fahed-男': 'ar-KW-FahedNeural',
    '阿拉伯语(科威特)-Noura-女': 'ar-KW-NouraNeural',
    '阿拉伯语(黎巴嫩)-Layla-女': 'ar-LB-LaylaNeural',
    '阿拉伯语(黎巴嫩)-Rami-男': 'ar-LB-RamiNeural',
    '阿拉伯语(利比亚)-Iman-女': 'ar-LY-ImanNeural',
    '阿拉伯语(利比亚)-Omar-男': 'ar-LY-OmarNeural',
    '阿拉伯语(摩洛哥)-Jamal-男': 'ar-MA-JamalNeural',
    '阿拉伯语(摩洛哥)-Mouna-女': 'ar-MA-MounaNeural',
    '阿拉伯语(阿曼)-Abdullah-男': 'ar-OM-AbdullahNeural',
    '阿拉伯语(阿曼)-Aysha-女': 'ar-OM-AyshaNeural',
    '阿拉伯语(卡塔尔)-Amal-女': 'ar-QA-AmalNeural',
    '阿拉伯语(卡塔尔)-Moaz-男': 'ar-QA-MoazNeural',
    '阿拉伯语(叙利亚)-Amany-女': 'ar-SY-AmanyNeural',
    '阿拉伯语(叙利亚)-Laith-男': 'ar-SY-LaithNeural',
    '阿拉伯语(突尼斯)-Hedi-男': 'ar-TN-HediNeural',
    '阿拉伯语(突尼斯)-Reem-女': 'ar-TN-ReemNeural',
    '阿拉伯语(也门)-Maryam-女': 'ar-YE-MaryamNeural',
    '阿拉伯语(也门)-Saleh-男': 'ar-YE-SalehNeural',
    '阿拉伯语(南非)-Adri-女': 'af-ZA-AdriNeural',
    '阿拉伯语(南非)-Willem-男': 'af-ZA-WillemNeural',
    '阿塞拜疆语(阿塞拜疆)-Babek-男': 'az-AZ-BabekNeural',
    '阿塞拜疆语(阿塞拜疆)-Banu-女': 'az-AZ-BanuNeural',
    '保加利亚语(保加利亚)-Borislav-男': 'bg-BG-BorislavNeural',
    '保加利亚语(保加利亚)-Kalina-女': 'bg-BG-KalinaNeural',
    '孟加拉语(孟加拉国)-Nabanita-女': 'bn-BD-NabanitaNeural',
    '孟加拉语(孟加拉国)-Pradeep-男': 'bn-BD-PradeepNeural',
    '孟加拉语(印度)-Bashkar-男': 'bn-IN-BashkarNeural',
    '孟加拉语(印度)-Tanishaa-女': 'bn-IN-TanishaaNeural',
    '波斯尼亚语(波斯尼亚和黑塞哥维那)-Goran-男': 'bs-BA-GoranNeural',
    '波斯尼亚语(波斯尼亚和黑塞哥维那)-Vesna-女': 'bs-BA-VesnaNeural',
    '加泰罗尼亚语(西班牙)-Joana-女': 'ca-ES-JoanaNeural',
    '加泰罗尼亚语(西班牙)-Enric-男': 'ca-ES-EnricNeural',
    '捷克语(捷克共和国)-Antonin-男': 'cs-CZ-AntoninNeural',
    '捷克语(捷克共和国)-Vlasta-女': 'cs-CZ-VlastaNeural',
    '威尔士语(英国)-Aled-男': 'cy-GB-AledNeural',
    '威尔士语(英国)-Nia-女': 'cy-GB-NiaNeural',
    '印度尼西亚语(印度尼西亚)-Ardi-男': 'id-ID-ArdiNeural',
    '印度尼西亚语(印度尼西亚)-Gadis-女': 'id-ID-GadisNeural',
    '希伯来语(以色列)-Avri-男': 'he-IL-AvriNeural',
    '希伯来语(以色列)-Hila-女': 'he-IL-HilaNeural',
    '爱沙尼亚语(爱沙尼亚)-Anu-女': 'et-EE-AnuNeural',
    '爱沙尼亚语(爱沙尼亚)-Kert-男': 'et-EE-KertNeural',
    '波斯语(伊朗)-Dilara-女': 'fa-IR-DilaraNeural',
    '波斯语(伊朗)-Farid-男': 'fa-IR-FaridNeural',
    '芬兰语(芬兰)-Harri-男': 'fi-FI-HarriNeural',
    '芬兰语(芬兰)-Noora-女': 'fi-FI-NooraNeural',
    '爱尔兰语(爱尔兰)-Colm-男': 'ga-IE-ColmNeural',
    '爱尔兰语(爱尔兰)-Orla-女': 'ga-IE-OrlaNeural',
    '马来语(马来西亚)-Osman-男': 'ms-MY-OsmanNeural',
    '马来语(马来西亚)-Yasmin-女': 'ms-MY-YasminNeural',
    '加利西亚语(西班牙)-Roi-男': 'gl-ES-RoiNeural',
    '加利西亚语(西班牙)-Sabela-女': 'gl-ES-SabelaNeural',
    '古吉拉特语(印度)-Dhwani-女': 'gu-IN-DhwaniNeural',
    '古吉拉特语(印度)-Niranjan-男': 'gu-IN-NiranjanNeural',
    '印地语(印度)-Madhur-男': 'hi-IN-MadhurNeural',
    '印地语(印度)-Swara-女': 'hi-IN-SwaraNeural',
    '克罗地亚语(克罗地亚)-Gabrijela-女': 'hr-HR-GabrijelaNeural',
    '克罗地亚语(克罗地亚)-Srecko-男': 'hr-HR-SreckoNeural',
    '匈牙利语(匈牙利)-Noemi-女': 'hu-HU-NoemiNeural',
    '匈牙利语(匈牙利)-Tamas-男': 'hu-HU-TamasNeural',
    '冰岛语(冰岛)-Gudrun-女': 'is-IS-GudrunNeural',
    '冰岛语(冰岛)-Gunnar-男': 'is-IS-GunnarNeural',
    '爪哇语(印度尼西亚)-Dimas-男': 'jv-ID-DimasNeural',
    '爪哇语(印度尼西亚)-Siti-女': 'jv-ID-SitiNeural',
    '格鲁吉亚语(格鲁吉亚)-Eka-女': 'ka-GE-EkaNeural',
    '格鲁吉亚语(格鲁吉亚)-Giorgi-男': 'ka-GE-GiorgiNeural',
    '哈萨克语(哈萨克斯坦)-Aigul-女': 'kk-KZ-AigulNeural',
    '哈萨克语(哈萨克斯坦)-Daulet-男': 'kk-KZ-DauletNeural',
    '高棉语(柬埔寨)-Piseth-男': 'km-KH-PisethNeural',
    '高棉语(柬埔寨)-Sreymom-女': 'km-KH-SreymomNeural',
    '卡纳达语(印度)-Gagan-男': 'kn-IN-GaganNeural',
    '卡纳达语(印度)-Sapna-女': 'kn-IN-SapnaNeural',
    '老挝语(老挝)-Chanthavong-男': 'lo-LA-ChanthavongNeural',
    '老挝语(老挝)-Keomany-女': 'lo-LA-KeomanyNeural',
    '立陶宛语(立陶宛)-Leonas-男': 'lt-LT-LeonasNeural',
    '立陶宛语(立陶宛)-Ona-女': 'lt-LT-OnaNeural',
    '拉脱维亚语(拉脱维亚)-Everita-女': 'lv-LV-EveritaNeural',
    '拉脱维亚语(拉脱维亚)-Nils-男': 'lv-LV-NilsNeural',
    '马其顿语(北马其顿共和国)-Aleksandar-男': 'mk-MK-AleksandarNeural',
    '马其顿语(北马其顿共和国)-Marija-女': 'mk-MK-MarijaNeural',
    '马拉雅拉姆语(印度)-Midhun-男': 'ml-IN-MidhunNeural',
    '马拉雅拉姆语(印度)-Sobhana-女': 'ml-IN-SobhanaNeural',
    '蒙古语(蒙古)-Bataa-男': 'mn-MN-BataaNeural',
    '蒙古语(蒙古)-Yesui-女': 'mn-MN-YesuiNeural',
    '马拉地语(印度)-Aarohi-女': 'mr-IN-AarohiNeural',
    '马拉地语(印度)-Manohar-男': 'mr-IN-ManoharNeural',
    '马耳他语(马耳他)-Grace-女': 'mt-MT-GraceNeural',
    '马耳他语(马耳他)-Joseph-男': 'mt-MT-JosephNeural',
    '缅甸语(缅甸)-Nilar-女': 'my-MM-NilarNeural',
    '缅甸语(缅甸)-Thiha-男': 'my-MM-ThihaNeural',
    '尼泊尔语(尼泊尔)-Hemkala-女': 'ne-NP-HemkalaNeural',
    '尼泊尔语(尼泊尔)-Sagar-男': 'ne-NP-SagarNeural',
    '波兰语(波兰)-Marek-男': 'pl-PL-MarekNeural',
    '波兰语(波兰)-Zofia-女': 'pl-PL-ZofiaNeural',
    '普什图语(阿富汗)-Gul Nawaz-男': 'ps-AF-GulNawazNeural',
    '普什图语(阿富汗)-Latifa-女': 'ps-AF-LatifaNeural',
    '罗马尼亚语(罗马尼亚)-Alina-女': 'ro-RO-AlinaNeural',
    '罗马尼亚语(罗马尼亚)-Emil-男': 'ro-RO-EmilNeural',
    '僧伽罗语(斯里兰卡)-Sameera-男': 'si-LK-SameeraNeural',
    '僧伽罗语(斯里兰卡)-Thilini-女': 'si-LK-ThiliniNeural',
    '斯洛伐克语(斯洛伐克)-Lukas-男': 'sk-SK-LukasNeural',
    '斯洛伐克语(斯洛伐克)-Viktoria-女': 'sk-SK-ViktoriaNeural',
    '斯洛文尼亚语(斯洛文尼亚)-Petra-女': 'sl-SI-PetraNeural',
    '斯洛文尼亚语(斯洛文尼亚)-Rok-男': 'sl-SI-RokNeural',
    '索马里语(索马里)-Muuse-男': 'so-SO-MuuseNeural',
    '索马里语(索马里)-Ubax-女': 'so-SO-UbaxNeural',
    '阿尔巴尼亚语(阿尔巴尼亚)-Anila-女': 'sq-AL-AnilaNeural',
    '阿尔巴尼亚语(阿尔巴尼亚)-Ilir-男': 'sq-AL-IlirNeural',
    '塞尔维亚语(塞尔维亚)-Nicholas-男': 'sr-RS-NicholasNeural',
    '塞尔维亚语(塞尔维亚)-Sophie-女': 'sr-RS-SophieNeural',
    '巽他语(印度尼西亚)-Jajang-男': 'su-ID-JajangNeural',
    '巽他语(印度尼西亚)-Tuti-女': 'su-ID-TutiNeural',
    '斯瓦希里语(肯尼亚)-Rafiki-男': 'sw-KE-RafikiNeural',
    '斯瓦希里语(肯尼亚)-Zuri-女': 'sw-KE-ZuriNeural',
    '斯瓦希里语(坦桑尼亚)-Daudi-男': 'sw-TZ-DaudiNeural',
    '斯瓦希里语(坦桑尼亚)-Rehema-女': 'sw-TZ-RehemaNeural',
    '泰米尔语(印度)-Pallavi-女': 'ta-IN-PallaviNeural',
    '泰米尔语(印度)-Valluvar-男': 'ta-IN-ValluvarNeural',
    '泰米尔语(斯里兰卡)-Kumar-男': 'ta-LK-KumarNeural',
    '泰米尔语(斯里兰卡)-Saranya-女': 'ta-LK-SaranyaNeural',
    '泰米尔语(马来西亚)-Kani-女': 'ta-MY-KaniNeural',
    '泰米尔语(马来西亚)-Surya-男': 'ta-MY-SuryaNeural',
    '泰米尔语(新加坡)-Anbu-男': 'ta-SG-AnbuNeural',
    '泰卢固语(印度)-Mohan-男': 'te-IN-MohanNeural',
    '泰卢固语(印度)-Shruti-女': 'te-IN-ShrutiNeural',
    '土耳其语(土耳其)-Ahmet-男': 'tr-TR-AhmetNeural',
    '土耳其语(土耳其)-Emel-女': 'tr-TR-EmelNeural',
    '乌克兰语(乌克兰)-Ostap-男': 'uk-UA-OstapNeural',
    '乌克兰语(乌克兰)-Polina-女': 'uk-UA-PolinaNeural',
    '乌尔都语(印度)-Gul-女': 'ur-IN-GulNeural',
    '乌尔都语(印度)-Salman-男': 'ur-IN-SalmanNeural',
    '乌尔都语(巴基斯坦)-Asad-男': 'ur-PK-AsadNeural',
    '乌尔都语(巴基斯坦)-Uzma-女': 'ur-PK-UzmaNeural',
    '乌兹别克语(乌兹别克斯坦)-Madina-女': 'uz-UZ-MadinaNeural',
    '乌兹别克语(乌兹别克斯坦)-Sardor-男': 'uz-UZ-SardorNeural',
    '祖鲁语(南非)-Thando-女': 'zu-ZA-ThandoNeural',
    '祖鲁语(南非)-Themba-男': 'zu-ZA-ThembaNeural'
 }