# EXAONE-4.0
## 论文
[EXAONE-4.0](https://arxiv.org/abs/2507.11407)

## 模型简介
EXAONE4.0通过集成非推理模式与推理模式，实现了EXAONE3.5的卓越可用性与EXAONE Deep 的先进推理能力。为迈向智能体AI时代，EXAONE4.0引入了智能体工具调用等关键特性，并将多语言支持扩展至西班牙语（除英语、韩语外）。EXAONE4.0系列包含两种规模：  
- 32B中规模模型：针对高性能场景优化  
- 1.2B小规模模型：专为端侧应用设计  
<p style="text-indent: 0;">相较于前代模型，EXAONE4.0架构进行了以下革新：  
1. 混合注意力机制。
在32B模型中，我们采用混合注意力方案，以3:1的比例结合局部注意力（滑动窗口注意力）与全局注意力（全注意力）。为提升全局上下文理解能力，全局注意力模块未使用RoPE（旋转位置编码）。  
2. QK重归一化。
我们将传统Pre-LN方案中的层归一化位置重新调整：    
- 直接对注意力与 MLP 输出应用 LayerNorm
- 在Q（查询）与K（键）投影后立即引入RMS归一化  
该设计虽增加计算开销，但能显著提升下游任务性能。

## 环境依赖

| 软件 | 版本 |
| :------: | :------: |
| DTK | 25.04.2 |
| python | 3.10.12 |
| transformers | >=4.57.1 |
| vllm | 0.11.0+das.opt1.alpha.dtk25042.20251225.gca4598a4 |
| torch | 2.5.1+das.opt1.dtk25042 |
| triton | 3.1.0+das.opt1.dtk25042.20251224.gaa867475 |


推荐使用镜像:harbor.sourcefind.cn:5443/dcu/admin/base/vllm:0.11.0-ubuntu22.04-dtk25.04.2-tx-1226-das1.7-py3.10-20251226
- 挂载地址`-v`根据实际模型情况修改

```bash
docker run -it --shm-size 60g --network=host --name EXAONE --privileged --device=/dev/kfd --device=/dev/dri --device=/dev/mkfd --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -u root -v /opt/hyhal/:/opt/hyhal/:ro -v /path/your_code_path/:/path/your_code_path/  harbor.sourcefind.cn:5443/dcu/admin/base/vllm:0.11.0-ubuntu22.04-dtk25.04.2-tx-1226-das1.7-py3.10-20251226 bash
```
更多镜像可前往[光源](https://sourcefind.cn/#/service-list)下载使用。

关于本项目DCU显卡所需的特殊深度学习库可从[光合](https://developer.sourcefind.cn/tool/)开发者社区下载安装。

## 数据集
暂无

## 训练
暂无

## 推理

### vllm
#### 单机推理

```bash
## serve启动
可参考vllm_serve.sh脚本
vllm serve LGAI-EXAONE/EXAONE-4.0-1.2B   --trust-remote-code --dtype bfloat16 -tp 1 --max-model-len 32768 --port 8010
## client访问
可参考vllm_cilent.sh
curl -X POST "http://localhost:8010/v1/chat/completions"      -H "Content-Type: application/json"     --data '{
                "model": "LGAI-EXAONE/EXAONE-4.0-1.2B",
                "messages": [
                        {
                                "role": "user",
                                "content": "who are you"
                        }
                ]
        }'

```

## 效果展示
<div align=center>
    <img src="./doc/result.png"/>
</div>

### 精度
DCU与GPU精度一致，推理框架：vllm。

## 预训练权重
| 模型名称  | 权重大小  | DCU型号  | 最低卡数需求 |下载地址|
|:-----:|:----------:|:----------:|:---------------------:|:----------:|
| EXAONE-4.0-1.2B | 1.2B | K100AI | 1 | [下载地址](https://huggingface.co/LGAI-EXAONE/EXAONE-4.0-1.2B) |

## 源码仓库及问题反馈
- https://developer.sourcefind.cn/codes/modelzoo/exaone-4.0_vllm

## 参考资料
- https://github.com/LG-AI-EXAONE/EXAONE-4.0
