import cv2
import os

from glob import glob


def toavi(image_root,
          output_path,
          frame_rate: int = 16):
    image_path_list = list(glob(os.path.join(image_root, "*.png")))
    
    image_path_list.sort()
    
    frame = cv2.imread(image_path_list[0])
    height, width, layers = frame.shape
    
    fourcc = cv2.VideoWriter_fourcc(*'MJPG')
    video = cv2.VideoWriter(output_path, fourcc, frame_rate, (width, height))
    
    for image_path in image_path_list:
        frame = cv2.imread(image_path)
        video.write(frame)

    video.release()


if __name__ == "__main__":
    import argparse
    
    parser = argparse.ArgumentParser()
    
    parser.add_argument("--image_root", type=str)

    parser.add_argument("--output_path", type=str)
    
    args = parser.parse_args()
    # image_root = "/home/modelzoo/EvTexture/results/EvTexture_REDS4_BIx4/visualization/REDS4/test"
    # image_root = "/home/modelzoo/EvTexture/datasets/images/images"
    # output_path = "./low.avi"
    
    toavi(args.image_root, args.output_path)



