# EvTexture

## 论文

**EvTexture: Event-driven Texture Enhancement for Video Super-Resolution**

* https://arxiv.org/abs/2406.13457

## 模型结构

EvTexture采用双向循环网络，其中特征向前和向后传播。

![alt text](readme_imgs/models.png)

## 算法原理

在每个时间戳，使用一个运动分支和一个并行的纹理分支，以明确增强纹理区域的恢复。

![alt text](readme_imgs/alg.png)


## 环境配置

### Docker（方法一）
    
    docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.1.0-ubuntu20.04-dtk24.04.1-py3.10

    docker run --shm-size 50g --network=host --name=evtexture --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v 项目地址(绝对路径):/home/ -v /opt/hyhal:/opt/hyhal:ro -it <your IMAGE ID> bash

    pip install -r requirements.txt

    python setup.py develop


### Dockerfile（方法二）

    docker build -t <IMAGE_NAME>:<TAG> .

    docker run --shm-size 50g --network=host --name=evtexture --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v 项目地址(绝对路径):/home/ -v /opt/hyhal:/opt/hyhal:ro -it <your IMAGE ID> bash

    pip install -r requirements.txt

    python setup.py develop


### Anaconda (方法三)

1、关于本项目DCU显卡所需的特殊深度学习库可从光合开发者社区下载安装：
https://developer.hpccube.com/tool/

    DTK驱动：dtk24.04.1
    python：python3.10
    torch: 2.1.0
    torchvision: 0.16.0

Tips：以上dtk驱动、python、torch等DCU相关工具版本需要严格一一对应

2、其它非特殊库参照requirements.txt安装

    pip install -r requirements.txt

    python setup.py develop

## 数据集

[OneDriver](https://1drv.ms/f/c/2d90e71fb9eb254f/EnMm8c2mP_FPv6lwt1jy01YB6bQhoPQ25vtzAhycYisERw?e=DiI2Ab) | [SCNet](http://113.200.138.88:18080/aidatasets/project-dependency/evtexture) 高速下载通道

### 数据处理

该部分仅展示整体流程，详细请参考[DataPreparation](datasets/DataPreparation.md)。

- 将原始视频转换为图像（参考`datasets/utils/video_to_img.py`）；
- 将图像转换为HWC格式numpy类型的数据并以h5结构存储在`/path/to/xx.h5/images`中;
- 将视频转换为事件，包含forward及backward，分别存储在`/path/to/xx.h5/voxels_f`及`/path/to/xx.h5/voxels_b`中。

以上步骤可参考`datasets/dataproparation.py`，注意，该脚本并非官方版本，使用前请仔细检查。执行下述命令准备相应的环境。

    python -m pip install pybind11

    export CMAKE_PREFIX_PATH=/usr/local/lib/python3.10/site-packages/pybind11/share/cmake/pybind11/:$CMAKE_PREFIX_PATH

    sudo apt update

    sudo apt install libopencv-dev

    export CMAKE_PREFIX_PATH=/usr/lib/x86_64-linux-gnu/cmake/opencv4/:$CMAKE_PREFIX_PATH

    下载 eigen3 https://gitlab.com/libeigen/eigen/-/releases/3.4.0  (zip版本)

    unzip /path/to/eigen3.zip 
    cd /path/to/eigen3
    mkdir build && cd build 
    cmake .. && make 
    make install

    # 安装boost
    sudo apt install build-essential libboost-system-dev libboost-thread-dev libboost-program-options-dev libboost-test-dev

    sudo apt install libboost-all-dev

    cd others/rpg_vid2e/esim_pyt && python setup.py install

注意：数据处理或下载完成后，需按照`basicsr/data/meta_info`中的文件格式创建相应的文件。

## 推理

    export HIP_VISIBLE_DEVICES=0

    # 1表示使用DCU数量

    bash scripts/dist_test.sh 1 options/test/EvTexture/test_EvTexture_REDS4_BIx4.yml

    bash scripts/dist_test.sh 1 options/test/EvTexture/test_EvTexture_Vid4_BIx4.yml

## result

原始视频

<video width="320" height="240" controls>
  <source src="readme_imgs/ori_10y.avi" type="video/avi">
  Your browser does not support the video tag.
</video>

修复后视频

<video width="320" height="240" controls>
  <source src="readme_imgs/vid4_10y.avi" type="video/avi">
  Your browser does not support the video tag.
</video>

### 精度

无

## 应用场景

### 算法类别

`视频超分`

### 热点应用行业

`安防,媒体,环境`

## 预训练权重

[OneDriver](https://1drv.ms/f/c/2d90e71fb9eb254f/EnMm8c2mP_FPv6lwt1jy01YB6bQhoPQ25vtzAhycYisERw?e=DiI2Ab) | [SCNet](http://113.200.138.88:18080/aimodels/findsource-dependency/evtexture) 高速下载通道

    experiments/
    └── pretrained_models
        └── EvTexture
            ├── EvTexture_REDS_BIx4.pth
            └── EvTexture_Vimeo90K_BIx4.pth

## 源码仓库及问题反馈

* https://developer.hpccube.com/codes/modelzoo/evtexture_pytorch

## 参考资料

* https://github.com/DachunKai/EvTexture/tree/main
