import h5py

def print_hdf5_structure(file_name):
    def print_attrs(name, obj):
        print(f"{name}")
        for key, val in obj.attrs.items():
            print(f"    Attribute: {key}: {val}")

    with h5py.File(file_name, 'r') as f:
        f.visititems(print_attrs)

# # # 替换为你的 HDF5 文件路径
file_name = 'zbl2/test.h5'
print_hdf5_structure(file_name)


# with h5py.File(file_name, 'a') as h5f:
#     del h5f['voxels_b']
#     del h5f['voxels_f']


# import h5py

# # 打开H5文件
# with h5py.File('zbl2', 'r') as f:

#     # 列出所有子目录（组）
#     groups = list(f.keys())
#     print("子目录（组）:", groups)

#     # 选择一个子目录（例如第一个）
#     group_name = groups[0]
#     group = f[group_name]
#     print("选择的子目录:", group_name)

#     # 列出子目录中的所有文件（数据集）
#     datasets = list(group.keys())
#     print("数据集:", datasets)

#     # 选择一个数据集（例如第一个）
#     dataset_name = datasets[0]
#     dataset = group[dataset_name]
#     print("选择的数据集:", dataset_name)

#     # 输出数据集的内容
#     print("数据集的数据:")
#     print(dataset.shape)  # 输出整个数据集的内容
#     # 如果数据集很大，您可能只想输出一部分，比如 dataset[0:5] 来输出前5个数据点
