# Efficientnet_b2

## 模型介绍

EfficientNet B2是一种卷积神经网络模型，由Google Brain团队于2019年提出。它是EfficientNet系列的一部分，是在ImageNet数据集上进行训练的，具有高度优化的网络结构，可以有效地识别和分类图像。

## 模型结构

EfficientNet B2模型的网络结构可以分为三个部分：特征提取器、特征增强层和分类器。

首先，输入的图像经过一系列卷积层和池化层进行特征提取。EfficientNet B2使用了轻量级深度可分离卷积层和残差连接来减少计算时间和内存占用，并且采用了一种自适应扩张卷积（SE）模块来进一步提高表示能力。

接下来是特征增强层，它包括了一些额外的层来进一步提高特征表示能力。其中最重要的是MBConv6和MBConv6+两种类型的块。这些块通过复合缩放方法，在每个层面上增加了通道数和分辨率，提高了特征提取器的效率。

最后，将特征向量送入全局平均池化层得到一个固定大小的特征向量，然后通过一组全连接层将其映射到输出类别。分类器部分采用了Dropout正则化来防止过拟合。

## 数据集

在本测试中可以使用ImageNet数据集。

## Efficientnet_b2训练

### 环境配置

下载工程代码：

http://developer.hpccube.com/codes/aicomponent/mmclassification-mmcv.git

提供[光源](https://www.sourcefind.cn/#/service-details)拉取的训练的docker镜像：

* 训练镜像：docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:1.10.0-centos7.6-dtk-22.10.1-py37-latest
* pip install -r requirements.txt
* cd mmclassification    
* pip install -e .

### 训练

将训练数据解压到data目录下。

训练命令：

    ./efficientnet.sh

## 性能和准确率数据

测试数据使用的是ImageNet数据集，使用的加速卡是DCU Z100L。

| 卡数 |       性能       |           精度            |
| :--: | :--------------: | :-----------------------: |
|  8   | 1401.56samples/s | top1:0.73228;top5:0.91522 |

### 参考

https://github.com/open-mmlab/mmpretrain