# Efficientnet_b2

## 论文

EfficientNet: Rethinking Model Scaling for Convolutional Neural Networks

- https://arxiv.org/abs/1905.11946

## 模型介绍

EfficientNet B2是一种卷积神经网络模型，由Google Brain团队于2019年提出。它是EfficientNet系列的一部分，是在ImageNet数据集上进行训练的，具有高度优化的网络结构，可以有效地识别和分类图像。

![20231124102153](./images/20231124102153.png)

## 模型结构

EfficientNet B2模型的网络结构可以分为三个部分：特征提取器、特征增强层和分类器。

![20210419135003777](./images/20210419135003777.png)

## 环境配置

### Docker

```python
git clone --recursive http://developer.hpccube.com/codes/modelzoo/efficientnet_b2_mmcv.git
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:1.10.0-centos7.6-dtk-22.10.1-py37-latest
# <your IMAGE ID>用以上拉取的docker的镜像ID替换
docker run --shm-size 10g --network=host --name=nit-pytorch --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v $PWD/Efficientnet_b2_mmcv:/home/Efficientnet_b2_mmcv -it <your IMAGE ID> bash

cd Densenet121-mmcv/mmclassification-mmcv
pip install -r requirements.txt
```

## 数据集

在本测试中可以使用ImageNet数据集。

```
├── meta
├── train
├── val
```

### 训练

将训练数据解压到data目录下。

### 单机8卡

    ./efficientnet.sh

## 精度

测试数据使用的是ImageNet数据集，使用的加速卡是DCU Z100L。

| 卡数 |           精度            |
| :--: | :-----------------------: |
|  8   | top1:0.73228;top5:0.91522 |

## result

![img](https://developer.hpccube.com/codes/modelzoo/vit_pytorch/-/raw/master/image/README/1695381570003.png)

## 应用场景

### 算法类别

图像分类

### 热点行业

制造,能源,交通,网安

### 源码仓库及问题反馈

https://developer.hpccube.com/codes/modelzoo/efficientnet_b2_mmcv

### 参考

https://github.com/open-mmlab/mmpretrain