# Efficientnet_b2

## 论文

EfficientNet: Rethinking Model Scaling for Convolutional Neural Networks

- https://arxiv.org/abs/1905.11946

## 模型结构

EfficientNet B2是一种卷积神经网络模型，由Google Brain团队于2019年提出。它是EfficientNet系列的一部分，是在ImageNet数据集上进行训练的，具有高度优化的网络结构，可以有效地识别和分类图像。

![20231124102153](./images/20231124102153.png)

## 算法原理

EfficientNet B2模型的网络结构可以分为三个部分：特征提取器、特征增强层和分类器。

![20210419135003777](./images/20210419135003777.png)

## 环境配置

### Docker（方法一）

```python
git clone --recursive http://developer.hpccube.com/codes/modelzoo/efficientnet_b2_mmcv.git
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:1.10.0-centos7.6-dtk-22.10.1-py37-latest
# <your IMAGE ID>用以上拉取的docker的镜像ID替换
docker run --shm-size 10g --network=host --name=efficientnet_b2 --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v $PWD/efficientnet_b2_mmcv:/home/efficientnet_b2_mmcv -it <your IMAGE ID> bash

cd efficientnet_b2_mmcv/mmclassification-mmcv
pip install -r requirements.txt
```

### Dockerfile（方法二）

```plaintext
cd efficientnet_b2_mmcv/docker
docker build --no-cache -t efficientnet_b2_mmcv:latest .
docker run --rm --shm-size 10g --network=host --name=efficientnet_b2 --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v $PWD/../../efficientnet_b2_mmcv:/home/efficientnet_b2_mmcv -it <your IMAGE ID> bash
# 若遇到Dockerfile启动的方式安装环境需要长时间等待，可注释掉里面的pip安装，启动容器后再安装python库：pip install -r requirements.txt
```

### Anaconda（方法三）

1、关于本项目DCU显卡所需的特殊深度学习库可从光合开发者社区下载安装： https://developer.hpccube.com/tool/

```plaintext
DTK驱动：dtk22.10.1
python：python3.7
torch:1.10.0
torchvision:0.10.0
mmcv：1.6.1
Tips：以上dtk驱动、python、torch等DCU相关工具版本需要严格一一对应
```

2、其它非特殊库参照requirements.txt安装

```plaintext
pip install -r requirements.txt
```

## 数据集

在本测试中可以使用ImageNet数据集。

下载ImageNet数据集：https://image-net.org/

下载val数据：链接：https://pan.baidu.com/s/1oXsmsYahGVG3uOZ8e535LA?pwd=c3bc 提取码：c3bc 替换ImageNet数据集中的val目录，处理后的数据结构如下：

```
data
    ├──imagenet
        ├── meta
            ├──val.txt
            ├──train.txt
            ...
        ├── train
        ├── val
  
```

## 训练

将训练数据解压到data目录下。

### 单机8卡

    ./efficientnet.sh

## result

![img](https://developer.hpccube.com/codes/modelzoo/vit_pytorch/-/raw/master/image/README/1695381570003.png)

### 精度

测试数据使用的是ImageNet数据集，使用的加速卡是DCU Z100L。

| 卡数 |           精度            |
| :--: | :-----------------------: |
|  8   | top1:0.73228;top5:0.91522 |

## 应用场景

### 算法类别

图像分类

### 热点行业

制造,能源,交通,网安

## 源码仓库及问题反馈

https://developer.hpccube.com/codes/modelzoo/efficientnet_b2_mmcv

## 参考资料

https://github.com/open-mmlab/mmpretrain
