# DragGAN 
DragGAN 模型，是一种革命性交互式图像操作方式，允许用户将图像中的任意点“拖动”到目标位置，以精确控制姿势、形状、表情和布局。

## 论文
`Drag Your GAN: Interactive Point-based Manipulation on the Generative Image Manifold`
- https://arxiv.org/abs/2305.10973
- SIGGRAPH 2023

## 模型结构
<!-- 此处一句话简要介绍模型结构 -->
DragGAN是一种用于 GAN 的交互式图像处理方法。主要是基于 StyleGAN 模型架构：

<div align=center>
    <img src="./doc/StyleGan.png"/>
    <div >StyleGan</div>
</div>


## 算法原理
对于给定的图像，只需要设置几个处理点（红点）、目标点（蓝点），以及可选的表示编辑过程中可移动区域（较亮区域）的掩码。我们的方法迭代地执行运动监督和点跟踪。运动监控步骤驱动手柄点（红点）朝向目标点（蓝点）移动，点跟踪步骤更新手柄点以跟踪图像中的对象。此过程将继续，直到控制点达到其相应的目标点。

<div align=center>
    <img src="./doc/pipeline.png"/>
    <div >DragGAN</div>
</div>


## 环境配置
```
mv draggan_pytoch draggan # 去框架名后缀
# docker的-v 路径、docker_name和imageID根据实际情况修改
```
### Docker（方法一）
<!-- 此处提供[光源](https://www.sourcefind.cn/#/service-details)拉取docker镜像的地址与使用步骤 -->
```
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.1.0-ubuntu20.04-dtk24.04.2-py3.10 # 本镜像imageID为：2f1f619d0182
docker run -it -v /path/your_code_data/:/path/your_code_data/ -v /opt/hyhal/:/opt/hyhal/:ro --shm-size=16G --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video --network=host --name docker_name imageID bash
cd /your_code_path/draggan
pip install -r requirements.txt
```
### Dockerfile（方法二）
<!-- 此处提供dockerfile的使用方法 -->
```
cd /your_code_path/draggan/docker
docker build --no-cache -t codestral:latest .
docker run -it -v /path/your_code_data/:/path/your_code_data/ -v /opt/hyhal/:/opt/hyhal/:ro --shm-size=16G --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video --network=host --name docker_name imageID bash
cd /your_code_path/draggan
pip install -r requirements.txt
```
### Anaconda（方法三）
<!-- 此处提供本地配置、编译的详细步骤，例如： -->

关于本项目DCU显卡所需的特殊深度学习库可从[光合](https://developer.hpccube.com/tool/)开发者社区下载安装。
```
DTK驱动: dtk24.04.2
python: python3.10
pytorch: 2.1.0
```
`Tips：以上DTK驱动、python、pytorch等DCU相关工具版本需要严格一一对应`

其它非深度学习库参照requirements.txt安装：
```
pip install -r requirements.txt
```
## 数据集
无

## 训练
无

## 推理
下载模型权重:
```
python scripts/download_model.py
```
或者从 [SCNet](http://113.200.138.88:18080/aimodels/findsource-dependency/stylegan2_pytorch) 上快速下载，并放在 /checkpoints 文件夹下。

可视化webui推理：
```
python visualizer_drag_gradio.py --listen
```


## result
<!-- 此处填算法效果测试图（包括输入、输出） -->


<div align=center>
    <img src="./doc/gradio.png" width=600/>
    <div >webui界面</div>
</div>

<div align=center>
    <img src="./doc/image.png" width=600/>
    <div >输入</div>
</div>

<div align=center>
    <img src="./doc/image (1).png" width=600/>
    <div >输出</div>
</div>


### 精度
无



## 应用场景
### 算法类别

<!-- 超出以上分类的类别命名也可参考此网址中的类别名：https://huggingface.co/ \ -->
`AIGC`

### 热点应用行业
<!-- 应用行业的填写需要做大量调研，从而为使用者提供专业、全面的推荐，除特殊算法，通常推荐数量>=3。 -->
`零售,制造,电商,医疗,教育`

<!-- ## 预训练权重 -->
<!-- - 此处填写预训练权重在公司内部的下载地址（预训练权重存放中心为：[SCNet AIModels](http://113.200.138.88:18080/aimodels) ，模型用到的各预训练权重请分别填上具体地址。），过小权重文件可打包到项目里。
- 此处填写公开预训练权重官网下载地址（非必须）。 -->

## 源码仓库及问题反馈
<!-- - 此处填本项目gitlab地址 -->
- https://developer.sourcefind.cn/codes/modelzoo/draggan_pytorch
## 参考资料
- https://github.com/XingangPan/DragGAN

