# Dolphin-Mistral
## 论文
暂无

## 模型简介
Dolphin-Mistral-24B-Venice-Edition是与Venice.ai合作推进的项目，其目标是为Venice生态系统构建一个具备最高程度内容开放性的Mistral-24B-Edition，Dolphin的定位是成为通用型人工智能模型，其设计目标与支撑ChatGPT、Claude及Gemini的模型体系类似。然而，此类通用模型在为寻求集成AI能力的企业提供解决方案时，仍存在若干适配性挑战。  
- 这些模型持续掌控系统提示词（system prompt）的设定权限，可任意弃用或修改关键指令，这种封闭式管控机制常导致下游应用的兼容性故障。  
- 其持续掌控模型版本的发布与管理权限，可能以静默更新的方式变更模型行为，或弃用企业所依赖的旧版本模型。  
- 其持续掌控模型的价值观对齐机制，且该对齐方案采用通用化设计，无法针对具体应用场景进行定制化适配。  
- 此类模型可获取全部用户查询数据，并可能以不符合用户预期的方式使用这些信息。相比之下，Dolphin模型具有高度可调控性，将控制权交还给系统所有者：您可自主设定系统提示词、定义价值观对齐标准，并完全掌控数据主权。Dolphin不会强加预设的道德准则或约束条款——所有规范均由使用者自主定义。  

Dolphin是您的专属工具，作为您意志的延伸而存在。正如您需对使用刀具、枪支、火源、汽车或互联网的行为承担个人责任，您是通过Dolphin生成的所有内容的创造者与责任主体。


## 环境依赖

| 软件 | 版本 |
| :------: | :------: |
| DTK | 25.04.2 |
| python | 3.10.12 |
| transformers | >=4.57.1 |
| vllm |  0.9.2+das.opt1.dtk25042 |
| torch | 2.5.1+das.opt1.dtk25042 |
| triton | 3.1+das.opt1.3c5d12d.dtk25041 |
| flash_attn | 2.6.1+das.opt1.dtk2504 |
| flash_mla | 1.0.0+das.opt1.dtk25042 |

当前仅支持镜像:
- 挂载地址`-v`根据实际模型情况修改

```bash
docker run -it --shm-size 60g --network=host --name Dolphin --privileged --device=/dev/kfd --device=/dev/dri --device=/dev/mkfd --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -u root -v /opt/hyhal/:/opt/hyhal/:ro -v /path/your_code_path/:/path/your_code_path/  image.sourcefind.cn:5000/dcu/admin/base/vllm:0.9.2-ubuntu22.04-dtk25.04.2-py3.10 bash
```
更多镜像可前往[光源](https://sourcefind.cn/#/service-list)下载使用。

关于本项目DCU显卡所需的特殊深度学习库可从[光合](https://developer.sourcefind.cn/tool/)开发者社区下载安装。

## 数据集
暂无

## 训练
暂无

## 推理

### vllm
#### 单机推理
可参考vllm_serve.sh脚本
```bash
## serve启动

vllm serve dphn/Dolphin-Mistral-24B-Venice-Edition/ --trust-remote-code --dtype bfloat16 --max-seq-len-to-capture 32768 -tp 1 --max-model-len 32768
## client访问
可参考vllm_cilent.sh
curl -X POST "http://localhost:8000/v1/chat/completions"      -H "Content-Type: application/json"     --data '{
                "model": "dphn/Dolphin-Mistral-24B-Venice-Edition/",
                "messages": [
                        {
                                "role": "user",
                                "content": "请介绍下自己"
                        }
                ]
        }'

```

## 效果展示
<div align=center>
    <img src="./doc/result.png"/>
</div>

### 精度
DCU与GPU精度一致，推理框架：vllm。

## 预训练权重
| 模型名称  | 权重大小  | DCU型号  | 最低卡数需求 |下载地址|
|:-----:|:----------:|:----------:|:---------------------:|:----------:|
| Dolphin-Mistral-24B-Venice-Edition | 24B | K100AI | 1 | [下载地址](https://huggingface.co/dphn/Dolphin-Mistral-24B-Venice-Edition) |

## 源码仓库及问题反馈
- https://developer.sourcefind.cn/codes/modelzoo/dolphin-mistral_vllm

## 参考资料
- https://hf-mirror.com/dphn/Dolphin-Mistral-24B-Venice-Edition
