# DISC-FinLLM

**DISC-FinLLM 是一个专门针对金融场景下为用户提供专业、智能、全面的金融咨询服务的金融领域大模型，由[复旦大学数据智能与社会计算实验室 (Fudan-DISC)](http://fudan-disc.com) 开发并开源。**

## 论文

- [DISC-FinLLM: A Chinese Financial Large Language Model based on Multiple Experts Fine-tuning](https://arxiv.org/abs/2310.15205)

## 模型结构
Baichuan-13B是由百川智能继Baichuan-7B之后开发的包含130亿参数模型，它在高质量的语料上训练了1.4万亿tokens，超过LLaMA-13B 40%。
Baichuan 2 是百川智能推出的新一代开源大语言模型，采用 2.6 万亿Tokens 的高质量语料训练。

<div align="center">
    <img src="./images/transformer.jpg"/>
</div>

## 算法原理
DISC-FinLLM是基于我们构建的高质量金融数据集DISC-Fin-SFT在通用领域中文大模型Baichuan-13B-Chat上进行LoRA指令微调得到的金融大模型。

<div align=center>
    <img src="./images/transformer.png"/>
</div>


## 环境配置
### Docker（方法一）
[光源](https://www.sourcefind.cn/#/service-details)拉取docker镜像的地址与使用步骤
```
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.1.0-ubuntu22.04-dtk23.10.1-py310

docker run -it -v /path/your_code_data/:/path/your_code_data/ -v /opt/hyhal/:/opt/hyhal/:ro --shm-size=64G --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video --name DISC-FinLLM <your imageID> bash

cd /path/your_code_data/

pip install -r requirements.txt -i http://mirrors.aliyun.com/pypi/simple/ --trusted-host mirrors.aliyun.com

pip install bitsandbytes-0.43.0-py3-none-any.whl

pip install deepspeed-0.12.3+gitfe61783.abi0.dtk2310.torch2.1.0a0-cp310-cp310-manylinux2014_x86_64.whl
```

### Dockerfile（方法二）
```
cd /path/your_code_data/docker

docker build --no-cache -t disc-finllm:latest .

docker run --shm-size=64G --name disc-finllm -v /opt/hyhal:/opt/hyhal:ro --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video -v /path/your_code_data/:/path/your_code_data/ -it disc-finllm:latest bash

cd /path/your_code_data/

pip install bitsandbytes-0.43.0-py3-none-any.whl

pip install deepspeed-0.12.3+gitfe61783.abi0.dtk2310.torch2.1.0a0-cp310-cp310-manylinux2014_x86_64.whl
```

### Anaconda（方法三）

关于本项目DCU显卡所需的特殊深度学习库可从[光合](https://developer.hpccube.com/tool/)开发者社区下载安装。
```
DTK驱动：dtk23.10
python：python3.10
torch:2.1
torchvision: 0.16.0
apex: 1.1.0
deepspped: 0.12.3
bitsandbytes: 0.43.0
```
`Tips：以上dtk驱动、python、paddle等DCU相关工具版本需要严格一一对应`

```
conda create -n DISC-FinLLM python=3.10

cd /path/your_code_data/

pip install -r requirements.txt -i http://mirrors.aliyun.com/pypi/simple

pip install bitsandbytes-0.43.0-py3-none-any.whl

pip install deepspeed-0.12.3+gitfe61783.abi0.dtk2310.torch2.1.0a0-cp310-cp310-manylinux2014_x86_64.whl
```

## 数据集

**你可以在这里查看[资料分析评测](https://github.com/FudanDISC/DISC-FinLLM/tree/main/eval/computing_eval.json)、[时事分析评测](https://github.com/FudanDISC/DISC-FinLLM/tree/main/eval/retriever_eval.json)对应的数据集。**

### 自定义数据处理代码 
参考data_processor.py

```
import json

jsonl_file_path = '.../data/dataset_new.jsonl'
json_file_path = '../data/dataset_new.json'
data = []
with open(jsonl_file_path, 'r', encoding='utf-8') as file:
    for line in file:
        jsonl_data = json.loads(line)
        json_data = {
            "instruction": jsonl_data.get("context").split('\n')[0].replace('Instruction: ', ''),
            "input": jsonl_data.get("context").split('\n')[1].replace('Input: ', ''),
            "output": jsonl_data.get("target")
        }
        data.append(json_data)

with open(json_file_path, 'w', encoding='utf-8') as file:
    json.dump(data, file, ensure_ascii=False, indent=4)

print(data)
```

项目中已提供用于试验训练的迷你数据集，训练数据目录结构如下，用于正常训练的完整数据集请按此目录结构进行制备：
```
 ── data
    │   ├── computing_part.json
    │   ├── consulting_part.json
    │   ├── retrieval_part.json
    │   └── task_part.json
    │——————————
```

## 训练

### 单机多卡
```
bash multi_dcu_train.sh
```

### 单机单卡
```
bash sft_work_dtk.sh
```

## 推理
**运行推理代码时需将模型文件FinLLM中的文件替换下载的本地模型FinLLM文件,并且将cli_demo.py文件中的模型路径更换为本地模型路径。**

### 单机单卡
需将**cli_demo.py**中的**model_path**改为替换模型文件后的本地模型路径
```
python cli_demo.py
```

## result

<div align=center>
    <img src="./images/result.png"/>
</div>

### 精度
测试数据：[retrieval_part](data/retrieval_part.json)，使用的加速卡:V100S/K100。

根据测试结果情况填写表格：
| device | train_loss | train_runtime |eval_los |eval_runtime |
| :------: | :------: | :------: | :------: |:------: |
| V100s |  0.6173 | 458.827 | 0.6276 | 4.6428 |
| K100 | 0.6193 | 1424.4159 | 0.6269 | 14.4002 |

## 应用场景
### 算法类别
`文本分析`

### 热点应用行业
`金融,教育,政府,科研`

## 预训练权重

- [Hugging Face Go4miii/DISC-FinLLM](https://huggingface.co/Go4miii/DISC-FinLLM) 下载全参模型权重。

## 源码仓库及问题反馈
- http://developer.hpccube.com/codes/modelzoo/disc-finllm_pytorch.git

## 参考资料
- https://github.com/FudanDISC/DISC-FinLLM

