import hashlib

def calculate_sha1(file_path):
    sha1_hash = hashlib.sha1()
    with open(file_path,"rb") as f:
        # Read and update hash string value in blocks of 4K
        for byte_block in iter(lambda: f.read(4096),b""):
            sha1_hash.update(byte_block)
    return sha1_hash.hexdigest()

print(calculate_sha1("/home/wanglch/projects/LLaMA-Factory/data/retrieval_part.json")) # c25232270e00337ca3889a04b5ae023129c7c154