# DISC-FinLLM:
**DISC-FinLLM 是一个专门针对金融场景下为用户提供专业、智能、全面的**金融咨询服务**的金融领域大模型，由[复旦大学数据智能与社会计算实验室 (Fudan-DISC)](http://fudan-disc.com) 开发并开源。**

## 论文

- [论文地址] [DISC-FinLLM: A Chinese Financial Large Language Model based on Multiple Experts Fine-tuning](https://arxiv.org/abs/2310.15205)

- [huggingface预训练模型下载地址] <https://huggingface.co/Go4miii/DISC-FinLLM>

## 模型结构

### DISC-FinLLM模型结构
<div align="center">
<img align="center" src=images/transformer.jpg>
</div>


## 算法原理

DISC-FinLLM是基于我们构建的高质量金融数据集DISC-Fin-SFT在通用领域中文大模型Baichuan-13B-Chat上进行LoRA指令微调得到的金融大模型。

<div align="center">
<img align="center" src=images/transformer.png>
</div>


## 环境配置
### Docker（方法一）
```
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.1.0-ubuntu22.04-dtk23.10.1-py310

docker run -it -v /path/your_code_data/:/path/your_code_data/ -v /opt/hyhal/:/opt/hyhal/:ro --shm-size=64G --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video --name DISC-FinLLM <your imageID> bash

docker exec -it DISC-FinLLM bash

cd /path/your_code_data/DISC-FinLLM

pip install -r requirements.txt -i http://mirrors.aliyun.com/pypi/simple/ --trusted-host mirrors.aliyun.com
```
### Dockerfile（方法二）
```
cd /path/your_code_data/DISC-FinLLM/docker

docker build --no-cache -t DISC-FinLLM:latest .

docker run --shm-size=64G --name DISC-FinLLM -v /opt/hyhal:/opt/hyhal:ro --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video -v /path/your_code_data/:/path/your_code_data/ -it DISC-FinLLM bash
```
### Anaconda（方法三）

关于本项目DCU显卡所需的特殊深度学习库可从[光合](https://developer.hpccube.com/tool/)开发者社区下载安装。

```
DTK驱动：dtk23.10
python：python3.10
torch:2.1
torchvision: 0.16.0
apex: 1.1.0
deepspped: 0.12.3
```
```
conda create -n DISC-FinLLM python=3.10

conda activate DISC-FinLLM

cd /path/your_code_data/DISC-FinLLM

pip install -r requirements.txt -i http://mirrors.aliyun.com/pypi/simple
```


`Tips：以上dtk驱动、python、torch、deepspeed等DCU相关工具版本需要严格一一对应`

## 数据集

**你可以在这里查看[资料分析评测](https://github.com/FudanDISC/DISC-FinLLM/tree/main/eval/computing_eval.json)、[时事分析评测](https://github.com/FudanDISC/DISC-FinLLM/tree/main/eval/retriever_eval.json)对应的数据集。**

### 自定义数据处理代码 
参考data_processor.py

```
import json

jsonl_file_path = '.../data/dataset_new.jsonl'
json_file_path = '../data/dataset_new.json'
data = []
with open(jsonl_file_path, 'r', encoding='utf-8') as file:
    for line in file:
        jsonl_data = json.loads(line)
        json_data = {
            "instruction": jsonl_data.get("context").split('\n')[0].replace('Instruction: ', ''),
            "input": jsonl_data.get("context").split('\n')[1].replace('Input: ', ''),
            "output": jsonl_data.get("target")
        }
        data.append(json_data)

with open(json_file_path, 'w', encoding='utf-8') as file:
    json.dump(data, file, ensure_ascii=False, indent=4)

print(data)
```


项目中已提供用于试验训练的迷你数据集，训练数据目录结构如下，用于正常训练的完整数据集请按此目录结构进行制备：
```
 ── data
    │   ├── computing_part.json
    │   ├── consulting_part.json
    │   ├── retrieval_part.json
    │   └── task_part.json
    │——————————
```
## 训练
**运行训练代码时需将模型文件FinLLM中的文件替换下载的本地模型FinLLM文件**
### 单机多卡
```
bash multi_dcu_train.sh
```
### 单机单卡
```
bash sft_work_dtk.sh
```

## 推理
**运行推理代码时需将模型文件FinLLM中的文件替换下载的本地模型FinLLM文件,并且将cli_demo.py文件中的模型路径更换为本地模型路径。**
### 单机单卡
需将**cli_demo.py**中的**model_path**改为替换模型文件后的本地模型路径
```
python cli_demo.py
```
### web交互推理
需将**web_demo.py**中的**model_path**改为替换模型文件后的本地模型路径
```
python web_demo.py
```

## result
DISC-FinLLM是一个金融领域的大语言模型，是由面向不同金融场景的4个模组：金融咨询、金融文本分析、金融计算、金融知识检索问答构成的多专家智慧金融系统。这些模组分别在金融NLP任务、人类试题、资料分析和时事分析等四个评测中展现出明显优势，证明了DISC-FinLLM能为广泛的金融领域提供强有力的支持。DISC-FinLLM能在不同应用场景下提供帮助，可用于实现不同的功能：

* **金融咨询：** 该模组可以在中国金融语境下，与用户展开关于金融话题的多轮对话，或是为用户解释金融专业的相关知识，是由数据集中的金融咨询指令部分训练而来。
* **金融文本分析：** 该模组可以帮助用户在金融文本上完成的信息抽取、情感分析、文本分类、文本生成等NLP任务，是由数据集中的金融任务指令部分训练而来。
* **金融计算：** 该模组可以帮助用户完成与数学计算相关的任务，除了利率、增长率等基本计算，它还支持统计分析和包括Black-Scholes期权定价模型、EDF预期违约概率模型在内的金融模型计算。这一模组是由数据集中的金融计算指令部分训练而来。
* **金融知识检索问答：** 该模组可以基于金融新闻、研报和相关政策文件为用户提供投资建议、时事分析、政策解读。它是由数据集中的检索增强指令部分训练而来。

<div align="center">
<img align="center" src=images/result.png>
</div>

### 精度
测试数据：[retrieval_part](data/retrieval_part.json)，使用的加速卡:V100S/K100。

根据测试结果情况填写表格：
| xxx | train_loss | train_runtime |eval_los |eval_runtime |
| :------: | :------: | :------: | :------: |:------: |
| V100s |  0.6173 | 458.827 | 0.6276 | 4.6428 |
| K100 | 0.6193 | 1424.4159 | 0.6269 | 14.4002 |


## 应用场景
金融,教育,政府,科研

### 算法类别

金融咨询,金融计算,文本分析

## 预训练权重
- [Hugging Face Go4miii/DISC-FinLLM](https://huggingface.co/Go4miii/DISC-FinLLM) 下载全参模型权重。
   

## 参考资料
- 本项目gitlab地址[Go4miii/DISC-FinLLM](https://github.com/FudanDISC/DISC-FinLLM)

