# DETR
## 论文
[End-to-End Object Detection with Transformers](https://arxiv.org/abs/2005.12872)

## 模型结构

对于输入图像, DETR使用传统的CNN backbone来学习2D特征, 并在将其传递到transformer encoder之前用positional encoding对其进行补充和平滑。然后, transformer decoder将少量固定数量的学习到的positional embeddings(对象查询)作为输入, 额外关注encoder输出。将解码器的每个输出embedding传递到预测检测（类和边界框）或“无对象”类的共享前馈网络（FFN）。

<div align=center>
    <img src="./doc/models.png"/>
</div>

## 算法原理
DETR将目标检测看作一种set prediction问题, 并提出了一个十分简洁的目标检测pipeline, 即CNN提取基础特征, 送入Transformer做关系建模, 得到的输出通过二分图匹配算法与图片上的ground truth做匹配。

<div align=center>
    <img src="./doc/DETR.png"/>
</div>

## 环境配置
-v 路径、docker_name和imageID根据实际情况修改

### Docker（方法一）

```
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:1.13.1-centos7.6-dtk-23.04.1-py38-latest

docker run -it -v /path/your_code_data/:/path/ your_code_data/ --shm-size=32G --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video --name docker_name imageID bash

cd /your_code_path/detr_pytorch
pip install -r requirements.txt
```

### Dockerfile（方法二）

```
cd ./docker
cp ../requirements.txt requirements.txt

docker build --no-cache -t detr:latest .
docker run -it -v /path/your_code_data/:/path/your_code_data/ --shm-size=32G --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video --name docker_name imageID bash

cd /your_code_path/detr_pytorch
pip install -r requirements.txt
```

### Anaconda（方法三）

1、关于本项目DCU显卡所需的特殊深度学习库可从光合开发者社区下载安装: https://developer.hpccube.com/tool/

```
DTK软件栈: dtk23.04.1
python: python3.8
torch: 1.13.1
torchvision: 0.14.1
```

Tips: 以上dtk软件栈、python、torch等DCU相关工具版本需要严格一一对应

2、其他非特殊库直接按照requirements.txt安装

```
pip install -r requirements.txt
```

## 数据集

COCO2017

[训练数据](http://images.cocodataset.org/zips/train2017.zip)

[验证数据](http://images.cocodataset.org/zips/val2017.zip)

[测试数据](http://images.cocodataset.org/zips/test2017.zip)

[标签数据](https://github.com/ultralytics/yolov5/releases/download/v1.0/coco2017labels.zip)

数据集的目录结构如下:

```
├── COCO2017
│   ├── images
│       ├── train2017
│       ├── val2017
│       └── test2017
│   ├── annotations
│       ├── instances_train2017.json
│       └── instances_val2017.json
```

训练/验证集数据准备:

训练/验证集都是采用的COCO的数据格式, 如果使用自己的标注数据, 请先将标注数据转换成COCO的格式, 并按照上面的目录结构进行存放。

## 训练

### 单机多卡

```
bash train.sh
```

## 推理

验证前需提前准备好预训练模型, 可从最下面的**参考资料**项目中提供的模型下载, 并将coco_path设置为当前环境中推理数据的对应地址, 数据应为COCO数据格式。

如果想要查看预测效果（预测结果输出到图片上）, 请执行(其余参数如backbone等需与训练模型参数需一致, 详情请根据训练参数配置):

```
python test.py --pre_trained_model <checkpoint path> --coco_path <coco path>
```

#### 单卡推理

```
bash val.sh
```

## result

<div align=center>
    <img src="./doc/000000001503.jpg"/>
</div>

### 精度

在COCO2017的val数据集上进行R50 backbone的单卡测试, 结果如下表所示:

| name | backbone | schedule | box AP |
| :------: | :------: | :------: | :------: |
| DETR(our)  | R50 | 500 | 39.8 |
| DETR  | R50 | 500 | 39.9 |


## 应用场景
### 算法类别
目标检测

### 热点应用行业
网安,交通,政府

## 源码仓库及问题反馈
http://developer.hpccube.com/codes/modelzoo/detr_pytorch.git

## 参考资料
https://github.com/facebookresearch/detr.git
