# Densenet121

## 模型介绍

DenseNet-121是一种深度卷积神经网络，由Kaiming He等人于2017年提出。它是DenseNet系列中的一种，也是其中最流行的一种，被广泛应用于计算机视觉领域的图像分类、目标检测和语义分割等任务。

## 模型结构

DenseNet-121的主要特点是密集连接（Dense Connection）。在传统的卷积神经网络中，每层只是简单地将输入映射到输出。而在DenseNet中，每层的输出都会连接到下一层的输入上，从而使得网络中的信息流更加充分，避免了信息的丢失。这种密集连接的方式也使得网络的训练更加容易，减少了梯度消失问题的发生。

DenseNet-121的结构由4个密集块（Dense Block）和3个过渡层（Transition Layer）组成。其中，每个密集块中包含若干个卷积层和池化层，每个卷积层都会接收前面所有层的输入，并将它们连接到自己的输出上。而过渡层则用于将前面密集块的输出进行降维，减少参数数量。

## 数据集

在本测试中可以使用ImageNet数据集。

## DenseNet-121训练

### 环境配置

下载工程代码：

http://developer.hpccube.com/codes/aicomponent/mmclassification-mmcv.git

提供[光源](https://www.sourcefind.cn/#/service-details)拉取的训练的docker镜像：

* 训练镜像：docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:1.10.0-centos7.6-dtk-22.10.1-py37-latest
* pip install -r requirements.txt
* cd mmclassification    
* pip install -e .

### 训练

将训练数据解压到data目录下。

训练命令：

    ./densenet121.sh

## 性能和准确率数据

测试数据使用的是ImageNet数据集，使用的加速卡是DCU Z100L。

| 卡数 |       性能       |           精度            |
| :--: | :--------------: | :-----------------------: |
|  8   | 1912.39samples/s | top1:0.74044;top5:0.91672 |

### 参考

https://github.com/open-mmlab/mmpretrain