# DenseNet121

## 论文

Densely Connected Convolutional Networks

- https://arxiv.org/pdf/1608.06993.pdf

## 模型结构

DenseNet-121是一种深度卷积神经网络，如图所示，由Kaiming He等人于2017年提出。它是DenseNet系列中的一种，也是其中最流行的一种，被广泛应用于计算机视觉领域的图像分类、目标检测和语义分割等任务。

![image-20231120204030674](./images/image-20231120204030674.png)

## 算法原理

DenseNet的核心组件为“Dense Block”，如图所示，由Dense connectivity和Transition Layer组成。每个密集块中包含若干个卷积层和池化层，每个卷积层都会接收前面所有层的输入，并将它们连接到自己的输出上。而过渡层则用于将前面密集块的输出进行降维，减少参数数量。

![image-20231120204212494](./images/image-20231120204212494.png)

## 环境配置

### Docker（方法一）

推荐使用docker方式运行，拉取提供的docker镜像

```shell
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.1.0-ubuntu20.04-dtk24.04.1-py3.10
```

基于拉取的镜像创建容器

```shell
# <your IMAGE ID or NAME>用以上拉取的docker的镜像ID或名称替换
docker run -it --name=densenet121_mmcv --network=host --ipc=host --shm-size=16g  --device=/dev/kfd --device=/dev/dri --device=/dev/mkfd --group-add video --privileged --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v /opt/hyhal:/opt/hyhal:ro <your IMAGE ID> bash
```

克隆并安装git仓库，安装相关依赖

```python
git clone --recursive http://developer.sourcefind.cn/codes/modelzoo/densenet121_mmcv.git
cd densenet121_mmcv/mmpretrain-mmcv
pip install -e .
pip install -r requirements.txt
```

### Dockerfile（方法二）

```bash
cd densenet121_mmcv/docker
docker build --no-cache -t densenet121_mmcv:latest .
docker run -it --name=efficientnet_b2_mmcv --network=host --ipc=host --shm-size=16g  --device=/dev/kfd --device=/dev/dri --device=/dev/mkfd --group-add video --privileged --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v /opt/hyhal:/opt/hyhal:ro <your IMAGE ID> bash
pip install -e .
# 若遇到Dockerfile启动的方式安装环境需要长时间等待，可注释掉里面的pip安装，启动容器后再安装python库：
# pip install -r requirements.txt
```

### Anaconda（方法三）

1、关于本项目DCU显卡所需的特殊深度学习库可从光合开发者社区下载安装： https://developer.sourcefind.cn/tool/

```plaintext
DTK驱动: DTK-24.04.1
python==3.10
torch==2.1.0
torchvision==0.16.0+das1.1.git7d45932.abi1.dtk2404.torch2.1
mmcv==2.0.1+das1.1.gite58da25.abi1.dtk2404.torch2.1.0
Tips：以上dtk驱动、python、torch等DCU相关工具版本需要严格一一对应
```

2、其它非特殊库参照requirements.txt安装

```plaintext
pip install -r requirements.txt
```

## 数据集

### ImageNet

在本项目中可以使用ImageNet数据集。ImageNet数据集官方下载地址：https://image-net.org。
按照以下方式解包:

```bash
cd mmpretrain-mmcv/data/imagenet
mkdir train && cd train
tar -xvf ILSVRC2012_img_train.tar
```

解包后是1000个tar文件，每个tar对应了一个类别，分别解包至对应文件夹，可利用如下shell脚本。

```bash
for tarfile in *.tar; do
    dirname="${tarfile%.tar}"
    mkdir "$dirname"
    tar -xvf "$tarfile" -C "$dirname"
done
```

将训练数据集解压后放置于mmpretrain-mmcv/data/，对于imagenet，目录结构如下

```
data
└── imagenet
    ├── train
    │   ├── n01440764
    │   │   ├── n01440764_10026.JPEG
    │   │   ├── n01440764_10027.JPEG
    ├──val
    │   ├── n01440764 
    │   │   ├── ILSVRC2012_val_00000293.JPEG
```

### Tiny-ImageNet-200

由于ImageNet完整数据集较大，可以使用[tiny-imagenet-200](http://cs231n.stanford.edu/tiny-imagenet-200.zip)进行测试 ，此时需要对配置脚本进行一些修改。可参照mmpretrain-mmcv子仓库中进行设置，其中也提供了使用tiny-imagenet-200数据集进行训练的若干配置脚本。

将训练数据集解压后放置于mmpretrain-mmcv/data/，对于tiny-imagenet，目录结构如下：

```
data
└── imagenet
    ├── test/
    ├── train/
    ├── val/
    ├── wnids.txt
    └── words.txt
```

## 训练

- tiny-imagenet-200

```shell
bash tools/dist_train.sh densenet121-test.py  8
```

- imagenet

```shell
bash tools/dist_train.sh configs/densenet/densenet121_4xb256_in1k.py 8
```

tips：如需其他卡数训练，将命令中的8改为所需卡数即可；如遇端口占用问题，可在tools/dist_train.sh修改端口。

## Result

![img](https://developer.sourcefind.cn/codes/modelzoo/vit_pytorch/-/raw/master/image/README/1695381570003.png)

### 精度

测试数据使用的是ImageNet数据集，使用的加速卡是DCU Z100L。

| 卡数  | 精度                        |
|:---:|:-------------------------:|
| 8   | top1:0.74044;top5:0.91672 |

## 应用场景

### 算法类别

图像分类

### 热点行业

制造,能源,交通,网安,安防

## 源码仓库及问题反馈

http://developer.sourcefind.cn/codes/modelzoo/densenet121_mmcv

## 参考资料

https://github.com/open-mmlab/mmpretrain
