# Densenet121

## 论文

Densely Connected Convolutional Networks

- https://arxiv.org/pdf/1608.06993.pdf

## 模型介绍

DenseNet-121是一种深度卷积神经网络，如图所示，由Kaiming He等人于2017年提出。它是DenseNet系列中的一种，也是其中最流行的一种，被广泛应用于计算机视觉领域的图像分类、目标检测和语义分割等任务。

![image-20231120204030674](./images/image-20231120204030674.png)

## 模型结构

DenseNet的核心组件为“Dense Block”，如图所示，由Dense connectivity和Transition Layer组成。每个密集块中包含若干个卷积层和池化层，每个卷积层都会接收前面所有层的输入，并将它们连接到自己的输出上。而过渡层则用于将前面密集块的输出进行降维，减少参数数量。

![image-20231120204212494](./images/image-20231120204212494.png)

## 环境配置

### Docker（方法一）

```python
git clone --recursive http://developer.hpccube.com/codes/modelzoo/densenet121_mmcv.git
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:1.10.0-centos7.6-dtk-22.10.1-py37-latest
# <your IMAGE ID>用以上拉取的docker的镜像ID替换
docker run --shm-size 10g --network=host --name=nit-pytorch --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v $PWD/Densenet121-mmcv:/home/Densenet121-mmcv -it <your IMAGE ID> bash

cd Densenet121-mmcv/mmclassification-mmcv
pip install -r requirements.txt
```

## 数据集

在本测试中可以使用ImageNet数据集。

下载ImageNet数据集：https://image-net.org/

下载val数据：链接：https://pan.baidu.com/s/1oXsmsYahGVG3uOZ8e535LA?pwd=c3bc 
提取码：c3bc 
替换ImageNet数据集中的val目录，处理后的数据结构如下：

```
├── meta
├── train
├── val
```

### 训练

将训练数据解压到data目录下。

### 单机8卡

    ./densenet121.sh

## 精度

测试数据使用的是ImageNet数据集，使用的加速卡是DCU Z100L。

| 卡数 |           精度            |
| :--: | :-----------------------: |
|  8   | top1:0.74044;top5:0.91672 |

## result

![img](https://developer.hpccube.com/codes/modelzoo/vit_pytorch/-/raw/master/image/README/1695381570003.png)

## 应用场景

### 算法类别

图像分类

### 热点行业

制造，能源，交通，网安

### 源码仓库及问题反馈

http://developer.hpccube.com/codes/modelzoo/densenet121_mmcv.git

### 参考

https://github.com/open-mmlab/mmpretrain