# DeepSeek-V2

## 论文
`DeepSeek-V2: A Strong, Economical, and Efficient Mixture-of-Experts Language Model`
- [https://arxiv.org/abs/2405.04434](https://arxiv.org/abs/2405.04434)

## 模型结构
DeepSeek-V2 是一种强大的专家混合(MoE)语言模型，其特点是经济的训练和高效的推理。模型结构上，该模型采用创新架构，包括多头潜在注意力(MLA)和DeepSeekMoE。MLA 通过将键值(KV)缓存显著压缩为潜在向量来保证高效推理，而 DeepSeekMoE 则通过稀疏计算以经济的成本训练强大的模型。DeepSeek-V2模型总共包含 236B 个参数，其中每个Token激活21B参数，支持长达128K的上下文长度。与 DeepSeek 67B 相比，DeepSeek-V2 实现了更强的性能，同时节省了 42.5% 的训练成本，KV 缓存降低了 93.3%，并将最大生成吞吐量提升到 5.76 倍。

DeepSeek-V2-Lite模型则凭借其轻量级设计和高效的性能，为MoE模型研究和应用开辟了新的方向。DeepSeek-V2-Lite总共 16B 参数，每个Token激活2.4B参数。相比于DeepSeek-V2，其参数量减少了近10倍，对训练和推理方面的显存需求都大大减少。


## 算法原理
DeepSeek-V2仍然采用Transformer架构，其中每个Transformer块由一个注意力模块和一个前馈网络(FFN)组成。然而，对于注意力模块和FFN，都设计和采用了创新架构。对于注意力机制，设计MLA，它利用低秩K-V联合压缩来消除推理时间K-V缓存的瓶颈，从而支持高效推理。对于FFN，采用DeepSeek MoE架构，这是一种高性能的MoE架构，能够以经济的成本训练出强大的模型。下图展示了DeepSeek-V2的架构：其中MLA 通过显著减少生成的 KV 缓存来确保高效推理，而 DeepSeek MoE 通过稀疏架构以经济的成本训练出强大的模型。

<div align="center">
<img src="deepseekv2.png" width="550" height="500">
</div>

## 环境配置

### Docker(方式一)
推荐使用docker方式运行，提供拉取的docker镜像：
```
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.1.0-ubuntu20.04-dtk24.04.1-py3.10
```

进入docker，安装docker中没有的依赖:
```
docker run -it --network=host --name=deepseekv2-train --privileged --device=/dev/kfd --device=/dev/dri  --ipc=host --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -u root --ulimit stack=-1:-1 --ulimit memlock=-1:-1  -v /root/.ssh:/root/.ssh -v /opt/hyhal:/opt/hyhal:ro  image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.1.0-ubuntu20.04-dtk24.04.1-py3.10 /bin/bash

docker exec -it deepseekv2-train /bin/bash
pip install -r requirements.txt -i http://mirrors.aliyun.com/pypi/simple/ --trusted-host mirrors.aliyun.com
```
### Dockerfile(方式二)
```
docker build -t deepseekv2-train:latest .
docker run -dit --network=host --name=deepseekv2-train --privileged --device=/dev/kfd --device=/dev/dri --ipc=host --shm-size=16G  --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -u root --ulimit stack=-1:-1 --ulimit memlock=-1:-1 -v /opt/hyhal/:/opt/hyhal/:ro deepseekv2-train:latest
docker exec -it deepseekv2-train /bin/bash
```

### Conda（方法三）
1. 创建conda虚拟环境：
```
conda create -n deepseekv2-train python=3.10
```

2. 关于本项目DCU显卡所需的工具包、深度学习库等均可从[光合](https://developer.hpccube.com/tool/)开发者社区下载安装。
- [DTK 24.04.1](https://cancon.hpccube.com:65024/1/main/DTK-24.04.1)
- [Pytorch 2.1.0](https://cancon.hpccube.com:65024/4/main/pytorch/DAS1.1)
- [Deepspeed 0.12.3](https://cancon.hpccube.com:65024/4/main/deepspeed/DAS1.1)
- [Flash_attn 2.0.4](https://cancon.hpccube.com:65024/4/main/flash_attn/DAS1.1)

    Tips：以上dtk驱动、python、deepspeed等工具版本需要严格一一对应。

3. 其它依赖库参照requirements.txt安装：
```
pip install -r requirements.txt
```

## 数据集
数据可按需进行自行准备，项目中已提供用于试验训练的数据集，因数据较大，已压缩至./examples/deepseek_v2/data.tar.gz，请解压后自行放至合适位置，并按数据位置修改./examples/deepseek_v2/run_pretrain_deepseek_xx.sh内数据路径为对应数据的绝对路径，具体可见训练步骤，训练数据目录结构如下，用于正常训练的完整数据集请按此目录结构进行制备：
```
 ── data
    │   ├── mmap_deepseekv2_datasets_text_document.bin
    │   └── mmap_deepseekv2_datasets_text_document.idx
```
## 预训练模型下载
ModelScope模型下载地址：
[DeepSeek-V2-Lite-Chat](https://www.modelscope.cn/models/deepseek-ai/DeepSeek-V2-Lite-Chat)
[DeepSeek-V2-Chat](https://www.modelscope.cn/models/deepseek-ai/DeepSeek-V2-Chat)

## 模型格式转换
若您需要进行模型的从头预训练，则可以跳过该步骤；若您想进行模型的继续预训练，则需要进行模型格式的转换，MoE模型的格式转换命令如下，其中模型切分方式可以根据需求自行修改：
```
cd ./toolkits/model_checkpoints_convertor/deepseek \
bash hf2mcore_deepseek_v2_moe_convertor.sh \
A2.4B \
/mnt/deepseek-ckpts/DeepSeek-V2-Lite \
/mnt/deepseek-ckpts/DeepSeek-V2-Lite-to-mcore-tp1-pp1-ep4 \
1 \
1 \
4 \
false
```

## 训练

### 作业提交
通过mpirun进行测试提交，运行相应参数均位于./examples/deepseek_v2/run_pretrain_deepseek_xx.sh，可按实际需要进行相应修改，目前默认参数为实测推荐参数，注意到该参数配置是基于K100_AI给出。

此外，多机训练需配置机间/容器间免密登录。对于容器间的免密登录，在主机间已免密的情况下，可在启动容器时挂载主机的.ssh文件夹` -v /root/.ssh:/root/.ssh`，并在进入容器后通过命令指定一个端口，如:` /usr/sbin/sshd -p 2727`。

修改好之后，可按下述方式进行作业提交：
```
cd ./examples/deepseek_v2/
chmod u+x run_pretrain_deepseek_xx.sh
mpirun -np 16 --hostfile 2node --allow-run-as-root  -mca plm_rsh_args "-p 2727" --bind-to none run_pretrain_deepseek_16B.sh node90
```

## 应用场景
### 算法类别

`自然语言处理`

### 热点应用行业

`医疗,教育,科研,金融`


## 源码仓库及问题反馈

- https://developer.hpccube.com/codes/modelzoo/deepseekv2_pytorch

## 参考资料

- [Pai-Megatron-Patch](https://github.com/alibaba/Pai-Megatron-Patch/tree/main)

