# DeepSeek-V3

## 论文

`DeepSeek-V3 Technical Report`

* https://github.com/deepseek-ai/DeepSeek-V3/blob/main/DeepSeek_V3.pdf


## 模型结构

该模型基于Transformer，采用Multi-Head Latent Attention和DeepSeekMoE架构，其中MLA通过减少KV缓存降低内存占用可用于高效推理，DeepSeekMoE通过auxiliary loss平衡专家负载。

![alt text](readme_imgs/arch.png)

## 算法原理

DeepSeek-V3的模型结构通过MLA、DeepSeekMoE、辅助损失无关的负载均衡策略、多令牌预测和FP8混合精度训练等创新技术，显著提升了模型的性能和训练效率。这些设计使得DeepSeek-V3在保持高性能的同时，大幅降低了训练成本。


## 环境配置

### Docker（方法一）
    
    docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.3.0-ubuntu22.04-dtk24.04.3-py3.10

    docker run --shm-size 500g --network=host --name=dpskv3 --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v 项目地址(绝对路径):/home/ -v /opt/hyhal:/opt/hyhal:ro -it <your IMAGE ID> bash

    cd inference
    pip install -r requirements.txt

### Dockerfile（方法二）

    docker build -t <IMAGE_NAME>:<TAG> .

    docker run --shm-size 500g --network=host --name=dpskv3 --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v 项目地址(绝对路径):/home/ -v /opt/hyhal:/opt/hyhal:ro -it <your IMAGE ID> bash

    cd inference
    pip install -r requirements.txt


## 数据集

无

## 训练

无

## 推理

注意：运行该模型需要4x8x64(GB)显存。

### 模型转换

```bash
# fp8 -> bf16
cd inference
python fp8_cast_bf16.py --input-fp8-hf-path /path/to/fp8_weights --output-bf16-hf-path /path/to/bf16_weights
```

```bash
# 模型划分
python convert.py --hf-ckpt-path /path/to/DeepSeek-V3-bf16 --save-path /path/to/DeepSeek-V3-Demo --n-experts 256 --model-parallel 32
```

### run

```bash
# chat
torchrun --nnodes 4 --nproc-per-node 8 --node-rank $RANK --master-addr $ADDR generate.py --ckpt-path /path/to/DeepSeek-V3-Demo --config configs/config_671B.json --interactive --temperature 0.7 --max-new-tokens 200
```

```bash
# 直接推理
torchrun --nnodes 4 --nproc-per-node 8 --node-rank $RANK --master-addr $ADDR generate.py --ckpt-path /path/to/DeepSeek-V3-Demo --config configs/config_671B.json --input-file $FILE
```

注意：需要将/path/to/fp8_weights中的json文件复制到/path/to/DeepSeek-V3-Demo中。

## result

![alt text](readme_imgs/result.png)

### 精度

无

## 应用场景

### 算法类别

`对话问答`

### 热点应用行业

`电商,教育,广媒`

## 预训练权重

[huggingface](https://hf-mirror.com/deepseek-ai/DeepSeek-V3) | [SCNet高速下载通道](http://113.200.138.88:18080/aimodels/deepseek-ai/DeepSeek-V3)


## 源码仓库及问题反馈

* https://developer.sourcefind.cn/codes/modelzoo/deepseek-v3_pytorch

## 参考资料

* https://github.com/deepseek-ai/DeepSeek-V3
