# DeepSeek-V3.2-Exp
## 论文
[DeepSeek_V3.2](./DeepSeek_V3_2.pdf)

## 模型结构



## 算法原理


## 环境配置
### 硬件需求
DCU型号：K100AI,节点数量：4台,卡数：32 张。

`-v 路径`、`docker_name`和`imageID`根据实际情况修改

### Docker（方法一）
```bash
dcoker pull image.sourcefind.cn:5000/dcu/admin/base/vllm:0.9.2-ubuntu22.04-dtk25.04.1-rc5-rocblas104381-0915-das1.6-py3.10-20250916-rc2
docker run -it --shm-size 200g --network=host --name {docker_name} --privileged --device=/dev/kfd --device=/dev/dri --device=/dev/mkfd --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -u root -v /path/your_code_data/:/path/your_code_data/ -v /opt/hyhal/:/opt/hyhal/:ro {imageID} bash

cd /your_code_path/deepseek-v3.2-exp_pytorch

```

### Dockerfile（方法二）
```bash
cd docker
docker build --no-cache -t deepseek-v3.2-exp:latest .

docker run -it --shm-size 200g --network=host --name {docker_name} --privileged --device=/dev/kfd --device=/dev/dri --device=/dev/mkfd --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -u root -v /path/your_code_data/:/path/your_code_data/ -v /opt/hyhal/:/opt/hyhal/:ro {imageID} bash

cd /your_code_path/deepseek-v3.2-exp_pytorch

```

### Anaconda（方法三）
关于本项目DCU显卡所需的特殊深度学习库可从[光合](https://developer.sourcefind.cn/tool/)开发者社区下载安装。
```bash
DTK: 25.04.1
python: 3.10.12
torch: 2.5.1+das.opt1.dtk25041
vllm: 0.9.2+das.opt1.rc2.dtk25041
transformers: 4.55.0
```
`Tips：以上dtk驱动、pytorch等DCU相关工具版本需要严格一一对应`, 其它库安装方式如下：

```bash

```

## 数据集
无

## 训练
暂无

## 推理
1. 首先将模型转换成bf16格式
```bash
cd inference
# fp8转bf16
python fp8_cast_bf16.py --input-fp8-hf-path /path/to/DeepSeek-V3.2-Exp --output-bf16-hf-path /path/to/DeepSeek-V3.2-Exp-bf16
```
2. 进行模型划分
```bash
python convert.py --hf-ckpt-path /path/to/DeepSeek-V3.2-Exp-bf16 --save-path /path/to/DeepSeek-V3.2-Demo --n-experts 256 --model-parallel 32
```
> 注意：需要将/path/to/DeepSeek-V3.2-Exp中的json文件复制到/path/to/DeepSeek-V3.2-Demo中。

3. 启动推理
```bash
export NCCL_ALGO=Ring
export NCCL_PROTO=Simple
# chat
torchrun --nnodes 4 --nproc-per-node 8 --node-rank $RANK --master-addr $ADDR generate.py --ckpt-path /path/to/DeepSeek-V3-Demo --config config_671B_v3.2.json --interactive --temperature 0.7 --max-new-tokens 200
```

## result


### 精度


## 应用场景
### 算法类别
`对话问答`

### 热点应用行业
`制造,金融,教育,广媒`

## 预训练权重
- [DeepSeek-V3.2-Exp](https://huggingface.co/deepseek-ai/DeepSeek-V3.2-Exp)

## 源码仓库及问题反馈
- https://developer.sourcefind.cn/codes/modelzoo/deepseek-v3.2-exp_pytorch

## 参考资料
- https://huggingface.co/deepseek-ai/DeepSeek-V3.2-Exp
- https://github.com/deepseek-ai/DeepSeek-V3.2-Exp
