# deepseek-v2
## 论文
`DeepSeek-V2`
- https://arxiv.org/abs/2405.04434

## 模型结构
<div align=center>
    <img src="./doc/model.png"/>
</div>

## 算法原理
DeepSeek-V2对模型框架进行了全方位的创新，提出了媲美MHA的MLA（Multi-head Latent Attention）架构，大幅减少计算量和推理显存；自研Sparse结构DeepSeekMoE进一步将计算量降低到极致，两者结合最终实现模型性能跨级别的提升。

## 环境配置
-v 路径、docker_name和imageID根据实际情况修改

### Docker（方法一）
```bash
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.1.0-centos7.6-dtk24.04-py310
docker run -it -v /path/your_code_data/:/path/your_code_data/ -v /opt/hyhal/:/opt/hyhal/:ro --shm-size=80G --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video --name docker_name imageID bash

cd /your_code_path/deepseek-v2_pytorch
pip install -r requirements.txt
```

### Dockerfile（方法二）
```bash
cd docker
docker build --no-cache -t deepseek-v2:latest .
docker run -it -v /path/your_code_data/:/path/your_code_data/ -v /opt/hyhal/:/opt/hyhal/:ro --shm-size=80G --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video --name docker_name imageID bash

cd /your_code_path/deepseek-v2_pytorch
pip install -r requirements.txt
```

### Anaconda（方法三）
关于本项目DCU显卡所需的特殊深度学习库可从[光合](https://developer.hpccube.com/tool/)开发者社区下载安装。
```bash
DTK驱动: dtk24.04
python: python3.10
torch: 2.1.0
```
`Tips：以上dtk驱动、python、torch等DCU相关工具版本需要严格一一对应`

其它非深度学习库安装方式如下：
```bash
pip install -r requirements.txt
```

## 数据集
暂无

## 训练
暂无

## 推理
基于**Huggingface's Transformers**进行推理，根据本地模型地址设置`model_name_or_path`参数。

如未下载预训练模型，请通过[#预训练权重](#预训练权重)进行下载。

当然，本项目支持代码自动进行下载，需按照下方命令进行HF相关库的安装，当前可用模型为："deepseek-ai/DeepSeek-V2-Lite"、"deepseek-ai/DeepSeek-V2-Lite-Chat"。

```bash
pip install -U huggingface_hub hf_transfer
export HF_ENDPOINT=https://hf-mirror.com
```

### 文本扩写
```bash
python text_completion.py
```

### 对话
```bash
python chat_completion.py
```

## result
</div>
    <img src="./doc/chat_completion.png" width="500" height="300"/>
</div>

### 精度
暂无

## 应用场景
### 算法类别
对话问答

### 热点应用行业
金融,广媒,教育

## 预训练权重
[DeepSeek-V2](http://113.200.138.88:18080/aimodels/DeepSeek-V2)
[DeepSeek-V2-Lite](http://113.200.138.88:18080/aimodels/DeepSeek-V2-Lite)
[DeepSeek-V2-Chat](http://113.200.138.88:18080/aimodels/DeepSeek-V2-Chat)
[DeepSeek-V2-Lite-Chat](http://113.200.138.88:18080/aimodels/DeepSeek-V2-Lite-Chat)

部分模型目录结构如下：
```bash
├── model_save_path
│   ├── DeepSeek-V2
│       ├── LICENSE
│       ├── README.md
│       ├── config.json
│       ├── configuration_deepseek.py
│       ├── generation_config.json
│       ├── model-00001-of-000055.safetensors
│       ├── model-00002-of-000055.safetensors
│       ...
│       ├── model-00054-of-000055.safetensors
│       ├── model-00055-of-000055.safetensors
│       ├── model.safetensors.index.json
│       ├── modeling_deepseek.py
│       ├── tokenization_deepseek_fast.py
│       ├── tokenizer.json
│       └── tokenizer_config.json
│   ├── DeepSeek-V2-Lite
│       ├── LICENSE
│       ├── README.md
│       ├── config.json
│       ├── configuration_deepseek.py
│       ├── generation_config.json
│       ├── model-00001-of-000004.safetensors
│       ├── model-00002-of-000004.safetensors
│       ├── model-00003-of-000004.safetensors
│       ├── model-00004-of-000004.safetensors
│       ├── model.safetensors.index.json
│       ├── modeling_deepseek.py
│       ├── tokenization_deepseek_fast.py
│       ├── tokenizer.json
│       └── tokenizer_config.json
...
```

## 源码仓库及问题反馈
- https://developer.hpccube.com/codes/modelzoo/deepseek-v2_pytorch

## 参考资料
- https://github.com/deepseek-ai/DeepSeek-V2
- https://huggingface.co/deepseek-ai
