# DeepSeek-OCR-2
## 论文
[DeepSeek-OCR 2: Visual Causal Flow](DeepSeek_OCR2_paper.pdf)

## 模型简介
DeepSeek 将原本基于 CLIP 的编码器替换为轻量级语言模型（Qwen2-500M），将原有的 DeepEncoder 升级为 DeepEncoder V2。在完整保留前代能力的基础上，DeepEncoder V2 通过一种全新的架构设计，引入了因果推理能力（causal reasoning），实现了视觉编码从「固定扫描」向「语义推理」的范式转变。

<div align=center>
    <img src="./doc/fig1.png"/>
</div>

## 环境依赖

| 软件 | 版本 |
| :------: | :------: |
| DTK | 25.04.1 |
| python | 3.10.12 |
| torch | 2.4.1+das.opt1.dtk25041 |
| transformers | 4.46.3 |
| vllm | 0.8.5.post1+das.opt4.dtk25041 |
| flash_attn | 2.6.1+das.opt13.dtk2504 |


推荐使用镜像: image.sourcefind.cn:5000/dcu/admin/base/vllm:0.8.5-ubuntu22.04-dtk25.04.1-rc5-das1.6-py3.10-20250724

- 挂载地址`-v`根据实际模型情况修改

```bash
docker run -it \
    --shm-size 60g \
    --network=host \
    --name deepseek-ocr-2 \
    --privileged \
    --device=/dev/kfd \
    --device=/dev/dri \
    --device=/dev/mkfd \
    --group-add video \
    --cap-add=SYS_PTRACE \
    --security-opt seccomp=unconfined \
    -u root \
    -v /opt/hyhal/:/opt/hyhal/:ro \
    -v /path/your_code_data/:/path/your_code_data/ \
    image.sourcefind.cn:5000/dcu/admin/base/vllm:0.8.5-ubuntu22.04-dtk25.04.1-rc5-das1.6-py3.10-20250724 bash
```
关于本项目DCU显卡所需的特殊深度学习库可从[光合](https://developer.sourcefind.cn/tool/)开发者社区下载安装，其它包参照requirements.txt安装：
```
pip install -r requirements.txt
```

## 数据集
暂无

## 训练
暂无

## 推理
### transformers
#### 单机推理
> 模型地址，测试图片路径，输出路径根据实际情况修改。
```bash
export HIP_VISIBLE_DEVICES=0
python DeepSeek-OCR2-hf/run_dpsk_ocr2.py --model_name_or_path=deepseek-ai/DeepSeek-OCR-2 --image_file=doc/docstructbench_dianzishu_zhongwenzaixian-o.O-63686436.pdf_57.jpg --output_path=output/image
```

### vllm
> 模型地址，测试图片路径，输出路径请根据实际情况在`DeepSeek-OCR2-vllm/config.py`中修改。
```bash
export VLLM_USE_V1=0
export HIP_VISIBLE_DEVICES=0
# image：流式输出
python DeepSeek-OCR2-vllm/run_dpsk_ocr2_image.py

# pdf
python DeepSeek-OCR2-vllm/run_dpsk_ocr2_image.py
```

## 效果展示
<div align=center>
    <img src="./doc/docstructbench_dianzishu_zhongwenzaixian-o.O-63686436.pdf_57_result_with_boxes.jpg"/>
</div>

### 精度
DCU与GPU精度一致，推理框架：vllm。

## 预训练权重
| 模型名称  | 权重大小  | DCU型号  | 最低卡数需求 |下载地址|
|:-----:|:----------:|:----------:|:---------------------:|:----------:|
| DeepSeek-OCR-2 | 3B | BW1000 | 1 | [ModelScope](https://modelscope.cn/models/deepseek-ai/DeepSeek-OCR-2) |

## 源码仓库及问题反馈
- https://developer.sourcefind.cn/codes/modelzoo/deepseek-ocr-2_pytorch

## 参考资料
- https://github.com/deepseek-ai/DeepSeek-OCR-2
