#!/bin/bash
export HIP_VISIBLE_DEVICES=0,1,2,3
# test datasets
DATA_PATH="../data/Evol-Instruct-Code-80k-v1/EvolInstruct-Code-80k.json"
# output dir
OUTPUT_PATH="../outputs"
MODEL_PATH="../weights/DeepSeek-Coder/deepseek-coder-6.7b-instruct"
deepspeed --include="localhost:0,1,2,3" finetune_deepseekcoder.py \
    --model_name_or_path $MODEL_PATH \
    --data_path $DATA_PATH \
    --output_dir $OUTPUT_PATH \
    --num_train_epochs 3 \
    --model_max_length 2048 \
    --per_device_train_batch_size 2 \
    --per_device_eval_batch_size 1 \
    --gradient_accumulation_steps 4 \
    --evaluation_strategy "no" \
    --save_strategy "steps" \
    --save_steps 100 \
    --save_total_limit 100 \
    --learning_rate 2e-5 \
    --warmup_steps 10 \
    --logging_steps 1 \
    --lr_scheduler_type "cosine" \
    --gradient_checkpointing True \
    --report_to "all" \
    --deepspeed configs/ds_config_zero3.json \
    --bf16 True
```
