# DeepSeek-Coder
DeepSeek Coder V2系列基于Deepseek-V2改进而来，有16B和236B两个版本。
## 论文
`DeepSeek-Coder-V2: Breaking the Barrier of Closed-Source Models in Code Intelligence`<br>
[deepseek-coder-V2](https://arxiv.org/pdf/2406.11931)

## 模型结构
DeepSeek-Coder-V2模型采用和Deepseek-V2同样的MoE架构
<div align=center>
    <img src="./assets/model_framework.png"/>
</div>

## 算法原理
DeepSeek-V2对模型框架进行了全方位的创新，提出了媲美MHA的MLA（Multi-head Latent Attention）架构，大幅减少计算量和推理显存；自研Sparse结构DeepSeekMoE进一步将计算量降低到极致，两者结合最终实现模型性能跨级别的提升。
## 环境配置
-v 路径、docker_name和imageID根据实际情况修改

### Docker（方法一）

```bash
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.1.0-centos7.6-dtk24.04-py310
docker run -it -v /path/your_code_data/:/path/your_code_data/ -v /opt/hyhal/:/opt/hyhal/:ro --shm-size=80G --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video --name docker_name imageID bash

cd /your_code_path/deepseek-coder-v2_pytorch
pip install -r requirements.txt
pip install -U huggingface_hub hf_transfer
export HF_ENDPOINT=https://hf-mirror.com
```

### Dockerfile（方法二）

```bash
cd docker
docker build --no-cache -t deepseek-coder-v2:latest .
docker run -it -v /path/your_code_data/:/path/your_code_data/ -v /opt/hyhal/:/opt/hyhal/:ro --shm-size=80G --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video --name docker_name imageID bash

cd /your_code_path/deepseek-v2_pytorch
pip install -r requirements.txt
pip install -U huggingface_hub hf_transfer
export HF_ENDPOINT=https://hf-mirror.com

```

### Anaconda（方法三）
关于本项目DCU显卡所需的特殊深度学习库可从[光合](https://developer.hpccube.com/tool/)开发者社区下载安装。
```
DTK驱动: dtk24.04
python: python3.10
torch: 2.1.0
```
`Tips：以上dtk驱动、python、torch等DCU相关工具版本需要严格一一对应`

其它非深度学习库安装方式如下：
```bash
pip install -r requirements.txt
pip install -U huggingface_hub hf_transfer
export HF_ENDPOINT=https://hf-mirror.com
```

## 数据集
暂无

## 训练
暂无

## 推理
基于Huggingface's Transformers进行推理.<br>
模型下载后 默认需存放至weights文件夹中<br>
也可自行更改 inference.py文件中的 model_name 参数<br>
模型下载地址[快速下载](http://113.200.138.88:18080/aimodels/deepseek-ai) [官方下载](http://113.200.138.88:18080/aimodels/deepseek-ai)
```python
HIP_VISIBLE_DEVICES=0 python inference.py
```
## Result
prompt：write a quick sort algorithm in python.<br>
<div align=center>
    <img src="./assets/result.png"/>
</div>

### 精度
暂无

## 应用场景
### 算法类别
代码生成

### 热点应用行业
制造,能源,教育

## 预训练权重
模型目录结构如下：
```bash
# DeepSeek-Coder-V2-Lite-Instruct/
├── config.json
├── configuration_deepseek.py
├── generation_config.json
├── model-00001-of-000004.safetensors
├── model-00002-of-000004.safetensors
├── model-00003-of-000004.safetensors
├── model-00004-of-000004.safetensors
├── modeling_deepseek.py
├── model.safetensors.index.json
├── README.md
├── tokenization_deepseek_fast.py
├── tokenizer_config.json
└── tokenizer.json
```

## 源码仓库及问题反馈
- https://developer.hpccube.com/codes/modelzoo/deepseek-coder-v2_pytorch

## 参考资料
- https://github.com/deepseek-ai/DeepSeek-Coder-V2?tab=readme-ov-file
- https://huggingface.co/deepseek-ai
