#ifndef __DEEPLABV3_H__
#define __DEEPLABV3_H__

#include <migraphx/program.hpp>
#include <CommonDefinition.h>



namespace migraphxSamples{

 class DeepLabV3{
    public:
    DeepLabV3();

    ~DeepLabV3();

    ErrorCode Initialize(InitializationParameterOfSegmentation initParamOfSegmentationUnet);

    ErrorCode Segmentation(std::vector<cv::Mat> srcImages, std::vector<cv::Mat> & maskImages);

    private:
    cv::FileStorage configurationFile;

    migraphx::program net;
    cv::Size inputSize;
    std::string inputName;
    migraphx::shape inputShape;
    std::string outputName;
    migraphx::shape outputShape;
    std::string outputName2;
    migraphx::shape outputShape2;

    std::unordered_map<std::string, migraphx::argument> modalDataMap;
    void* inputBufferDevice;
    void* outputBufferDevice;
    void* outputBufferDevice2;
    void* outputBufferHost;
    void* outputBufferHost2;

    bool useInt8;
    bool useFP16;
    bool useOffloadCopy;

 };   

} // namespace migraphxSamples


#endif